/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v6_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpServerExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRouteBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.spring.webmvc.v6_0.JakartaHttpServletRequestGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v6_0.SpringWebMvcHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v6_0.SpringWebMvcTelemetry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public final class SpringWebMvcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webmvc-6.0";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpServletRequest, HttpServletResponse>> additionalExtractors = new ArrayList<AttributesExtractor<HttpServletRequest, HttpServletResponse>>();
    private final HttpServerAttributesExtractorBuilder<HttpServletRequest, HttpServletResponse> httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE);
    private final HttpSpanNameExtractorBuilder<HttpServletRequest> httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE);
    private final HttpServerRouteBuilder<HttpServletRequest> httpServerRouteBuilder = HttpServerRoute.builder((HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE);
    private Function<SpanNameExtractor<HttpServletRequest>, ? extends SpanNameExtractor<? super HttpServletRequest>> spanNameExtractorTransformer = Function.identity();
    private boolean emitExperimentalHttpServerMetrics = false;

    SpringWebMvcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpServletRequest, HttpServletResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<HttpServletRequest>, ? extends SpanNameExtractor<? super HttpServletRequest>> spanNameExtractor) {
        this.spanNameExtractorTransformer = spanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        this.httpServerRouteBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.emitExperimentalHttpServerMetrics = emitExperimentalHttpServerMetrics;
        return this;
    }

    public SpringWebMvcTelemetry build() {
        SpringWebMvcHttpAttributesGetter httpAttributesGetter = SpringWebMvcHttpAttributesGetter.INSTANCE;
        SpanNameExtractor<? super HttpServletRequest> spanNameExtractor = this.spanNameExtractorTransformer.apply((SpanNameExtractor<HttpServletRequest>)this.httpSpanNameExtractorBuilder.build());
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, spanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addContextCustomizer(this.httpServerRouteBuilder.build()).addOperationMetrics(HttpServerMetrics.get());
        if (this.emitExperimentalHttpServerMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpServerExperimentalMetrics.get());
        }
        return new SpringWebMvcTelemetry((Instrumenter<HttpServletRequest, HttpServletResponse>)builder.buildServerInstrumenter((TextMapGetter)JakartaHttpServletRequestGetter.INSTANCE));
    }
}

