/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.armeria.v1_3;

import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.server.HttpService;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpClientPeerServiceAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.armeria.v1_3.ArmeriaTelemetry;
import io.opentelemetry.instrumentation.armeria.v1_3.internal.ArmeriaHttpClientAttributesGetter;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import io.opentelemetry.javaagent.instrumentation.armeria.v1_3.ResponseCustomizingDecorator;
import io.opentelemetry.javaagent.instrumentation.armeria.v1_3.ServerDecorator;
import java.util.function.Function;

public final class ArmeriaSingletons {
    public static final Function<? super HttpClient, ? extends HttpClient> CLIENT_DECORATOR;
    public static final Function<? super HttpService, ? extends HttpService> SERVER_DECORATOR;

    private ArmeriaSingletons() {
    }

    static {
        ArmeriaTelemetry telemetry = ArmeriaTelemetry.builder((OpenTelemetry)GlobalOpenTelemetry.get()).setCapturedClientRequestHeaders(CommonConfig.get().getClientRequestHeaders()).setCapturedClientResponseHeaders(CommonConfig.get().getClientResponseHeaders()).setKnownMethods(CommonConfig.get().getKnownHttpRequestMethods()).addClientAttributeExtractor((AttributesExtractor)HttpClientPeerServiceAttributesExtractor.create((HttpClientAttributesGetter)ArmeriaHttpClientAttributesGetter.INSTANCE, (PeerServiceResolver)CommonConfig.get().getPeerServiceResolver())).setEmitExperimentalHttpClientMetrics(CommonConfig.get().shouldEmitExperimentalHttpClientTelemetry()).setEmitExperimentalHttpServerMetrics(CommonConfig.get().shouldEmitExperimentalHttpServerTelemetry()).build();
        CLIENT_DECORATOR = telemetry.newClientDecorator();
        Function libraryDecorator = telemetry.newServiceDecorator().compose(service -> new ResponseCustomizingDecorator((HttpService)service));
        SERVER_DECORATOR = service -> new ServerDecorator((HttpService)service, (HttpService)libraryDecorator.apply((HttpService)service));
    }
}

