/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.armeria.v1_3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.concurrent.CompletableFuture;

public final class CompletableFutureWrapper {
    private CompletableFutureWrapper() {
    }

    public static <T> CompletableFuture<T> wrap(CompletableFuture<T> future) {
        if (future == null) {
            return null;
        }
        Context context = Context.current();
        if (context != Context.root()) {
            return CompletableFutureWrapper.wrap(future, context);
        }
        return future;
    }

    private static <T> CompletableFuture<T> wrap(CompletableFuture<T> future, Context context) {
        CompletableFuture result = new CompletableFuture();
        result.whenComplete((value, throwable) -> {
            try (Scope ignored = context.makeCurrent();){
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete(value);
                }
            }
        });
        return result;
    }
}

