/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.armeria.v1_3;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRouteSource;

class ServerDecorator
extends SimpleDecoratingHttpService {
    private final HttpService libraryDelegate;

    ServerDecorator(HttpService delegate, HttpService libraryDelegate) {
        super(delegate);
        this.libraryDelegate = libraryDelegate;
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (!LocalRootSpan.current().getSpanContext().isValid()) {
            return this.libraryDelegate.serve(ctx, req);
        }
        String matchedRoute = ctx.config().route().patternString();
        if (matchedRoute == null || matchedRoute.isEmpty()) {
            matchedRoute = "/";
        } else if (!matchedRoute.startsWith("/")) {
            matchedRoute = "/" + matchedRoute;
        }
        Context otelContext = Context.current();
        HttpServerRoute.update((Context)otelContext, (HttpServerRouteSource)HttpServerRouteSource.SERVER, (String)matchedRoute);
        try {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        catch (Throwable throwable) {
            Span span = Span.fromContext((Context)otelContext);
            span.setStatus(StatusCode.ERROR);
            span.recordException(ErrorCauseExtractor.getDefault().extract(throwable));
            throw throwable;
        }
    }
}

