/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.armeria.v1_3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SubscriberWrapper<T>
implements Subscriber<T> {
    private static final Class<?> abortingSubscriberClass = SubscriberWrapper.getAbortingSubscriberClass();
    private static final Class<?> noopSubscriberClass = SubscriberWrapper.getNoopSubscriberClass();
    private final Subscriber<T> delegate;
    private final Context context;

    private static Class<?> getAbortingSubscriberClass() {
        try {
            return Class.forName("com.linecorp.armeria.common.stream.AbortingSubscriber");
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    private static Class<?> getNoopSubscriberClass() {
        try {
            return Class.forName("com.linecorp.armeria.common.stream.NoopSubscriber");
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    private SubscriberWrapper(Subscriber<T> delegate, Context context) {
        this.delegate = delegate;
        this.context = context;
    }

    private static <T> boolean isIgnored(Subscriber<T> delegate) {
        return abortingSubscriberClass != null && abortingSubscriberClass.isInstance(delegate) || noopSubscriberClass != null && noopSubscriberClass.isInstance(delegate);
    }

    public static <T> Subscriber<T> wrap(Subscriber<T> delegate) {
        if (SubscriberWrapper.isIgnored(delegate)) {
            return delegate;
        }
        Context context = Context.current();
        if (context != Context.root()) {
            return new SubscriberWrapper<T>(delegate, context);
        }
        return delegate;
    }

    public void onSubscribe(Subscription subscription) {
        try (Scope ignored = this.context.makeCurrent();){
            this.delegate.onSubscribe(subscription);
        }
    }

    public void onNext(T o) {
        try (Scope ignored = this.context.makeCurrent();){
            this.delegate.onNext(o);
        }
    }

    public void onError(Throwable throwable) {
        try (Scope ignored = this.context.makeCurrent();){
            this.delegate.onError(throwable);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.context.makeCurrent();){
            this.delegate.onComplete();
        }
    }
}

