/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.awslambdaevents.v2_2;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.AwsLambdaRequest;
import io.opentelemetry.javaagent.bootstrap.OpenTelemetrySdkAccess;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.awslambdaevents.v2_2.AwsLambdaInstrumentationHelper;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class AwsLambdaRequestHandlerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"com.amazonaws.services.lambda.runtime.RequestHandler"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"com.amazonaws.services.lambda.runtime.RequestHandler"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.named((String)"handleRequest")).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"com.amazonaws.services.lambda.runtime.Context"))), AwsLambdaRequestHandlerInstrumentation.class.getName() + "$HandleRequestAdvice");
    }

    public static class HandleRequestAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) Object arg, @Advice.Argument(value=1) com.amazonaws.services.lambda.runtime.Context context, @Advice.Local(value="otelInput") AwsLambdaRequest input, @Advice.Local(value="otelFunctionContext") Context functionContext, @Advice.Local(value="otelFunctionScope") Scope functionScope, @Advice.Local(value="otelMessageContext") Context messageContext, @Advice.Local(value="otelMessageScope") Scope messageScope) {
            input = AwsLambdaRequest.create((com.amazonaws.services.lambda.runtime.Context)context, (Object)arg, Collections.emptyMap());
            Context parentContext = AwsLambdaInstrumentationHelper.functionInstrumenter().extract(input);
            if (!AwsLambdaInstrumentationHelper.functionInstrumenter().shouldStart(parentContext, input)) {
                return;
            }
            functionContext = AwsLambdaInstrumentationHelper.functionInstrumenter().start(parentContext, input);
            functionScope = functionContext.makeCurrent();
            if (arg instanceof SQSEvent && AwsLambdaInstrumentationHelper.messageInstrumenter().shouldStart(functionContext, (Object)((SQSEvent)arg))) {
                messageContext = AwsLambdaInstrumentationHelper.messageInstrumenter().start(functionContext, (Object)((SQSEvent)arg));
                messageScope = messageContext.makeCurrent();
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) Object arg, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelInput") AwsLambdaRequest input, @Advice.Local(value="otelFunctionContext") Context functionContext, @Advice.Local(value="otelFunctionScope") Scope functionScope, @Advice.Local(value="otelMessageContext") Context messageContext, @Advice.Local(value="otelMessageScope") Scope messageScope) {
            if (messageScope != null) {
                messageScope.close();
                AwsLambdaInstrumentationHelper.messageInstrumenter().end(messageContext, (Object)((SQSEvent)arg), null, throwable);
            }
            if (functionScope != null) {
                functionScope.close();
                AwsLambdaInstrumentationHelper.functionInstrumenter().end(functionContext, input, null, throwable);
            }
            OpenTelemetrySdkAccess.forceFlush((int)1, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

