/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.executors;

import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.executors.PropagatedContext;
import io.opentelemetry.javaagent.bootstrap.executors.TaskAdviceHelper;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import java.util.concurrent.Callable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class CallableInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)Callable.class.getName()));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"call").and((ElementMatcher)ElementMatchers.takesArguments((int)0)).and((ElementMatcher)ElementMatchers.isPublic()), CallableInstrumentation.class.getName() + "$CallableAdvice");
    }

    public static class CallableAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope enter(@Advice.This Callable<?> task) {
            VirtualField virtualField = VirtualField.find(Callable.class, PropagatedContext.class);
            return TaskAdviceHelper.makePropagatedContextCurrent((VirtualField)virtualField, task);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exit(@Advice.Enter Scope scope) {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

