/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.executors;

import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

final class ExecutorMatchers {
    private static final Logger logger = Logger.getLogger(ExecutorMatchers.class.getName());
    private static final Set<String> INSTRUMENTED_EXECUTOR_NAMES;
    private static final List<String> INSTRUMENTED_EXECUTOR_PREFIXES;

    static ElementMatcher.Junction<TypeDescription> executorNameMatcher() {
        if (InstrumentationConfig.get().getBoolean("otel.instrumentation.executors.include-all", false)) {
            return ElementMatchers.any();
        }
        return new ElementMatcher.Junction.AbstractBase<TypeDescription>(){

            public boolean matches(TypeDescription target) {
                boolean allowed = INSTRUMENTED_EXECUTOR_NAMES.contains(target.getName());
                if (!allowed) {
                    for (String name : INSTRUMENTED_EXECUTOR_PREFIXES) {
                        if (!target.getName().startsWith(name)) continue;
                        allowed = true;
                        break;
                    }
                }
                if (logger.isLoggable(Level.FINE) && !allowed && ExecutorMatchers.isExecutor().matches((Object)target)) {
                    logger.log(Level.FINE, "Skipping executor instrumentation for {0}", target.getName());
                }
                return allowed;
            }
        };
    }

    static ElementMatcher<TypeDescription> isExecutor() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)Executor.class.getName()));
    }

    static ElementMatcher<TypeDescription> isThreadPoolExecutor() {
        return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)ThreadPoolExecutor.class.getName()));
    }

    private ExecutorMatchers() {
    }

    static {
        HashSet<String> combined = new HashSet<String>(Arrays.asList("akka.actor.ActorSystemImpl$$anon$1", "akka.dispatch.BalancingDispatcher", "akka.dispatch.Dispatcher", "akka.dispatch.Dispatcher$LazyExecutorServiceDelegate", "akka.dispatch.ExecutionContexts$sameThreadExecutionContext$", "akka.dispatch.forkjoin.ForkJoinPool", "akka.dispatch.ForkJoinExecutorConfigurator$AkkaForkJoinPool", "akka.dispatch.MessageDispatcher", "akka.dispatch.PinnedDispatcher", "com.google.common.util.concurrent.AbstractListeningExecutorService", "com.google.common.util.concurrent.MoreExecutors$ListeningDecorator", "com.google.common.util.concurrent.MoreExecutors$ScheduledListeningDecorator", "io.netty.channel.epoll.EpollEventLoop", "io.netty.channel.epoll.EpollEventLoopGroup", "io.netty.channel.MultithreadEventLoopGroup", "io.netty.channel.nio.NioEventLoop", "io.netty.channel.nio.NioEventLoopGroup", "io.netty.channel.SingleThreadEventLoop", "io.netty.util.concurrent.AbstractEventExecutor", "io.netty.util.concurrent.AbstractEventExecutorGroup", "io.netty.util.concurrent.AbstractScheduledEventExecutor", "io.netty.util.concurrent.DefaultEventExecutor", "io.netty.util.concurrent.DefaultEventExecutorGroup", "io.netty.util.concurrent.GlobalEventExecutor", "io.netty.util.concurrent.MultithreadEventExecutorGroup", "io.netty.util.concurrent.SingleThreadEventExecutor", "java.util.concurrent.AbstractExecutorService", "java.util.concurrent.CompletableFuture$ThreadPerTaskExecutor", "java.util.concurrent.Executors$DelegatedExecutorService", "java.util.concurrent.Executors$FinalizableDelegatedExecutorService", "java.util.concurrent.ForkJoinPool", "java.util.concurrent.ScheduledThreadPoolExecutor", "java.util.concurrent.ThreadPoolExecutor", "java.util.concurrent.ThreadPerTaskExecutor", "org.apache.tomcat.util.threads.ThreadPoolExecutor", "org.eclipse.jetty.util.thread.QueuedThreadPool", "org.eclipse.jetty.util.thread.ReservedThreadExecutor", "org.glassfish.grizzly.threadpool.GrizzlyExecutorService", "org.jboss.threads.EnhancedQueueExecutor", "org.apache.pekko.dispatch.BalancingDispatcher", "org.apache.pekko.dispatch.Dispatcher", "org.apache.pekko.dispatch.Dispatcher$LazyExecutorServiceDelegate", "org.apache.pekko.dispatch.ExecutionContexts$sameThreadExecutionContext$", "org.apache.pekko.dispatch.ForkJoinExecutorConfigurator$PekkoForkJoinPool", "org.apache.pekko.dispatch.MessageDispatcher", "org.apache.pekko.dispatch.PinnedDispatcher", "play.api.libs.streams.Execution$trampoline$", "play.shaded.ahc.io.netty.util.concurrent.ThreadPerTaskExecutor", "scala.concurrent.forkjoin.ForkJoinPool", "scala.concurrent.Future$InternalCallbackExecutor$", "scala.concurrent.impl.ExecutionContextImpl"));
        combined.addAll(InstrumentationConfig.get().getList("otel.instrumentation.executors.include", Collections.emptyList()));
        INSTRUMENTED_EXECUTOR_NAMES = Collections.unmodifiableSet(combined);
        INSTRUMENTED_EXECUTOR_PREFIXES = Collections.singletonList("slick.util.AsyncExecutor$");
    }
}

