/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.executors;

import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.executors.ExecutorAdviceHelper;
import io.opentelemetry.javaagent.bootstrap.executors.PropagatedContext;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class FutureInstrumentation
implements TypeInstrumentation {
    private static final Logger logger = Logger.getLogger(FutureInstrumentation.class.getName());
    private static final Collection<String> ALLOWED_FUTURES;

    public ElementMatcher<TypeDescription> typeMatcher() {
        final ElementMatcher.Junction hasFutureInterfaceMatcher = AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)Future.class.getName()));
        return new ElementMatcher.Junction.AbstractBase<TypeDescription>(){

            public boolean matches(TypeDescription target) {
                boolean allowed = ALLOWED_FUTURES.contains(target.getName());
                if (!allowed && hasFutureInterfaceMatcher.matches((Object)target)) {
                    logger.log(Level.FINE, "Skipping future instrumentation for {0}", target.getName());
                }
                return allowed;
            }
        }.and((ElementMatcher)hasFutureInterfaceMatcher);
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"cancel").and((ElementMatcher)ElementMatchers.returns(Boolean.TYPE)), FutureInstrumentation.class.getName() + "$CanceledFutureAdvice");
    }

    static {
        String[] allowed = new String[]{"akka.dispatch.forkjoin.ForkJoinTask", "akka.dispatch.forkjoin.ForkJoinTask$AdaptedCallable", "akka.dispatch.forkjoin.ForkJoinTask$AdaptedRunnable", "akka.dispatch.forkjoin.ForkJoinTask$AdaptedRunnableAction", "akka.dispatch.ForkJoinExecutorConfigurator$AkkaForkJoinTask", "akka.dispatch.Mailbox", "com.google.common.util.concurrent.AbstractFuture", "com.google.common.util.concurrent.AbstractFuture$TrustedFuture", "com.google.common.util.concurrent.ListenableFutureTask", "com.google.common.util.concurrent.SettableFuture", "io.netty.util.concurrent.CompleteFuture", "io.netty.util.concurrent.FailedFuture", "io.netty.util.concurrent.ScheduledFutureTask", "java.util.concurrent.CompletableFuture$BiApply", "java.util.concurrent.CompletableFuture$BiCompletion", "java.util.concurrent.CompletableFuture$BiRelay", "java.util.concurrent.CompletableFuture$ThreadPerTaskExecutor", "java.util.concurrent.CountedCompleter", "java.util.concurrent.ExecutorCompletionService$QueueingFuture", "java.util.concurrent.ForkJoinTask", "java.util.concurrent.ForkJoinTask$AdaptedCallable", "java.util.concurrent.ForkJoinTask$RunnableExecuteAction", "java.util.concurrent.FutureTask", "java.util.concurrent.RecursiveAction", "java.util.concurrent.ScheduledThreadPoolExecutor$ScheduledFutureTask", "org.apache.pekko.dispatch.ForkJoinExecutorConfigurator$PekkoForkJoinTask", "org.apache.pekko.dispatch.Mailbox", "scala.collection.parallel.AdaptiveWorkStealingForkJoinTasks$WrappedTask", "scala.concurrent.forkjoin.ForkJoinTask", "scala.concurrent.forkjoin.ForkJoinTask$AdaptedCallable", "scala.concurrent.forkjoin.ForkJoinTask$AdaptedRunnable", "scala.concurrent.forkjoin.ForkJoinTask$AdaptedRunnableAction", "scala.concurrent.impl.ExecutionContextImpl$AdaptedForkJoinTask"};
        ALLOWED_FUTURES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(allowed)));
    }

    public static class CanceledFutureAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void exit(@Advice.This Future<?> future) {
            VirtualField virtualField = VirtualField.find(Future.class, PropagatedContext.class);
            ExecutorAdviceHelper.cleanPropagatedContext((VirtualField)virtualField, future);
        }
    }
}

