/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.executors;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.bootstrap.executors.ContextPropagatingRunnable;
import io.opentelemetry.javaagent.bootstrap.executors.ExecutorAdviceHelper;
import io.opentelemetry.javaagent.bootstrap.executors.PropagatedContext;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.executors.ExecutorMatchers;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JavaExecutorInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ExecutorMatchers.executorNameMatcher().and(ExecutorMatchers.isExecutor());
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"execute").and((ElementMatcher)ElementMatchers.takesArgument((int)0, Runnable.class)).and((ElementMatcher)ElementMatchers.takesArguments((int)1)), JavaExecutorInstrumentation.class.getName() + "$SetExecuteRunnableStateAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"addTask").and((ElementMatcher)ElementMatchers.takesArgument((int)0, Runnable.class)).and((ElementMatcher)ElementMatchers.takesArguments((int)1)), JavaExecutorInstrumentation.class.getName() + "$SetExecuteRunnableStateAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"execute").and((ElementMatcher)ElementMatchers.takesArgument((int)0, ForkJoinTask.class)), JavaExecutorInstrumentation.class.getName() + "$SetJavaForkJoinStateAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"submit").and((ElementMatcher)ElementMatchers.takesArgument((int)0, Runnable.class)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)AgentElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.is(Future.class)))), JavaExecutorInstrumentation.class.getName() + "$SetSubmitRunnableStateAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"submit").and((ElementMatcher)ElementMatchers.takesArgument((int)0, Callable.class)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)AgentElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.is(Future.class)))), JavaExecutorInstrumentation.class.getName() + "$SetCallableStateAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"submit").and((ElementMatcher)ElementMatchers.takesArgument((int)0, ForkJoinTask.class)), JavaExecutorInstrumentation.class.getName() + "$SetJavaForkJoinStateAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.namedOneOf((String[])new String[]{"invokeAny", "invokeAll"}).and((ElementMatcher)ElementMatchers.takesArgument((int)0, Collection.class)), JavaExecutorInstrumentation.class.getName() + "$SetCallableStateForCallableCollectionAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"invoke").and((ElementMatcher)ElementMatchers.takesArgument((int)0, ForkJoinTask.class)), JavaExecutorInstrumentation.class.getName() + "$SetJavaForkJoinStateAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"schedule").and((ElementMatcher)ElementMatchers.takesArgument((int)0, Runnable.class)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)AgentElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.is(Future.class)))), JavaExecutorInstrumentation.class.getName() + "$SetSubmitRunnableStateAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"schedule").and((ElementMatcher)ElementMatchers.takesArgument((int)0, Callable.class)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)AgentElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.is(Future.class)))), JavaExecutorInstrumentation.class.getName() + "$SetCallableStateAdvice");
    }

    public static class SetCallableStateForCallableCollectionAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Collection<?> submitEnter(@Advice.Argument(value=0) Collection<? extends Callable<?>> tasks) {
            if (tasks == null) {
                return Collections.emptyList();
            }
            Context context = Java8BytecodeBridge.currentContext();
            for (Callable<?> task : tasks) {
                if (!ExecutorAdviceHelper.shouldPropagateContext((Context)context, task)) continue;
                VirtualField virtualField = VirtualField.find(Callable.class, PropagatedContext.class);
                ExecutorAdviceHelper.attachContextToTask((Context)context, (VirtualField)virtualField, task);
            }
            return tasks;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void submitExit(@Advice.Enter Collection<? extends Callable<?>> tasks, @Advice.Thrown Throwable throwable) {
            if (throwable != null) {
                for (Callable<?> task : tasks) {
                    if (task == null) continue;
                    VirtualField virtualField = VirtualField.find(Callable.class, PropagatedContext.class);
                    PropagatedContext propagatedContext = (PropagatedContext)virtualField.get(task);
                    ExecutorAdviceHelper.cleanUpAfterSubmit((PropagatedContext)propagatedContext, (Throwable)throwable);
                }
            }
        }
    }

    public static class SetCallableStateAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static PropagatedContext enterJobSubmit(@Advice.Argument(value=0) Callable<?> task) {
            Context context = Java8BytecodeBridge.currentContext();
            if (ExecutorAdviceHelper.shouldPropagateContext((Context)context, task)) {
                VirtualField virtualField = VirtualField.find(Callable.class, PropagatedContext.class);
                return ExecutorAdviceHelper.attachContextToTask((Context)context, (VirtualField)virtualField, task);
            }
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exitJobSubmit(@Advice.Enter PropagatedContext propagatedContext, @Advice.Thrown Throwable throwable, @Advice.Return Future<?> future) {
            if (propagatedContext != null && future != null) {
                VirtualField virtualField = VirtualField.find(Future.class, PropagatedContext.class);
                virtualField.set(future, (Object)propagatedContext);
            }
            ExecutorAdviceHelper.cleanUpAfterSubmit((PropagatedContext)propagatedContext, (Throwable)throwable);
        }
    }

    public static class SetSubmitRunnableStateAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static PropagatedContext enterJobSubmit(@Advice.Argument(value=0, readOnly=false) Runnable task) {
            Context context = Java8BytecodeBridge.currentContext();
            if (ExecutorAdviceHelper.shouldPropagateContext((Context)context, (Object)task)) {
                VirtualField virtualField = VirtualField.find(Runnable.class, PropagatedContext.class);
                return ExecutorAdviceHelper.attachContextToTask((Context)context, (VirtualField)virtualField, (Object)task);
            }
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exitJobSubmit(@Advice.Enter PropagatedContext propagatedContext, @Advice.Thrown Throwable throwable, @Advice.Return Future<?> future) {
            if (propagatedContext != null && future != null) {
                VirtualField virtualField = VirtualField.find(Future.class, PropagatedContext.class);
                virtualField.set(future, (Object)propagatedContext);
            }
            ExecutorAdviceHelper.cleanUpAfterSubmit((PropagatedContext)propagatedContext, (Throwable)throwable);
        }
    }

    public static class SetJavaForkJoinStateAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static PropagatedContext enterJobSubmit(@Advice.Argument(value=0) ForkJoinTask<?> task) {
            Context context = Java8BytecodeBridge.currentContext();
            if (ExecutorAdviceHelper.shouldPropagateContext((Context)context, task)) {
                VirtualField virtualField = VirtualField.find(ForkJoinTask.class, PropagatedContext.class);
                return ExecutorAdviceHelper.attachContextToTask((Context)context, (VirtualField)virtualField, task);
            }
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exitJobSubmit(@Advice.Enter PropagatedContext propagatedContext, @Advice.Thrown Throwable throwable) {
            ExecutorAdviceHelper.cleanUpAfterSubmit((PropagatedContext)propagatedContext, (Throwable)throwable);
        }
    }

    public static class SetExecuteRunnableStateAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static PropagatedContext enterJobSubmit(@Advice.Argument(value=0, readOnly=false) Runnable task) {
            Context context = Java8BytecodeBridge.currentContext();
            if (!ExecutorAdviceHelper.shouldPropagateContext((Context)context, (Object)task)) {
                return null;
            }
            if (ContextPropagatingRunnable.shouldDecorateRunnable((Runnable)task)) {
                task = ContextPropagatingRunnable.propagateContext((Runnable)task, (Context)context);
                return null;
            }
            VirtualField virtualField = VirtualField.find(Runnable.class, PropagatedContext.class);
            return ExecutorAdviceHelper.attachContextToTask((Context)context, (VirtualField)virtualField, (Object)task);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exitJobSubmit(@Advice.Enter PropagatedContext propagatedContext, @Advice.Thrown Throwable throwable) {
            ExecutorAdviceHelper.cleanUpAfterSubmit((PropagatedContext)propagatedContext, (Throwable)throwable);
        }
    }
}

