/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.executors;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.bootstrap.executors.ExecutorAdviceHelper;
import io.opentelemetry.javaagent.bootstrap.executors.PropagatedContext;
import io.opentelemetry.javaagent.bootstrap.executors.TaskAdviceHelper;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JavaForkJoinTaskInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)ForkJoinTask.class.getName()));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"exec").and((ElementMatcher)ElementMatchers.takesArguments((int)0)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())), JavaForkJoinTaskInstrumentation.class.getName() + "$ForkJoinTaskAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"fork").and((ElementMatcher)ElementMatchers.takesArguments((int)0)), JavaForkJoinTaskInstrumentation.class.getName() + "$ForkAdvice");
    }

    public static class ForkAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static PropagatedContext enterFork(@Advice.This ForkJoinTask<?> task) {
            Context context = Java8BytecodeBridge.currentContext();
            if (ExecutorAdviceHelper.shouldPropagateContext((Context)context, task)) {
                VirtualField virtualField = VirtualField.find(ForkJoinTask.class, PropagatedContext.class);
                return ExecutorAdviceHelper.attachContextToTask((Context)context, (VirtualField)virtualField, task);
            }
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exitFork(@Advice.Enter PropagatedContext propagatedContext, @Advice.Thrown Throwable throwable) {
            ExecutorAdviceHelper.cleanUpAfterSubmit((PropagatedContext)propagatedContext, (Throwable)throwable);
        }
    }

    public static class ForkJoinTaskAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope enter(@Advice.This ForkJoinTask<?> task) {
            VirtualField callableVirtualField;
            VirtualField runnableVirtualField;
            Scope newScope;
            VirtualField virtualField = VirtualField.find(ForkJoinTask.class, PropagatedContext.class);
            Scope scope = TaskAdviceHelper.makePropagatedContextCurrent((VirtualField)virtualField, task);
            if (task instanceof Runnable && null != (newScope = TaskAdviceHelper.makePropagatedContextCurrent((VirtualField)(runnableVirtualField = VirtualField.find(Runnable.class, PropagatedContext.class)), (Object)((Runnable)((Object)task))))) {
                if (null != scope) {
                    newScope.close();
                } else {
                    scope = newScope;
                }
            }
            if (task instanceof Callable && null != (newScope = TaskAdviceHelper.makePropagatedContextCurrent((VirtualField)(callableVirtualField = VirtualField.find(Callable.class, PropagatedContext.class)), (Object)((Callable)((Object)task))))) {
                if (null != scope) {
                    newScope.close();
                } else {
                    scope = newScope;
                }
            }
            return scope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exit(@Advice.Enter Scope scope) {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

