/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.executors;

import io.opentelemetry.javaagent.bootstrap.executors.ContextPropagatingRunnable;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.executors.ExecutorMatchers;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ThreadPoolExtendingExecutorInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ExecutorMatchers.executorNameMatcher().and(ExecutorMatchers.isThreadPoolExecutor());
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"beforeExecute").and((ElementMatcher)ElementMatchers.takesArgument((int)1, Runnable.class)), this.getClass().getName() + "$BeforeExecuteAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"afterExecute").and((ElementMatcher)ElementMatchers.takesArgument((int)0, Runnable.class)), this.getClass().getName() + "$AfterExecuteAdvice");
    }

    public static class AfterExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0, readOnly=false) Runnable runnable) {
            if (runnable instanceof ContextPropagatingRunnable) {
                runnable = ((ContextPropagatingRunnable)runnable).unwrap();
            }
        }
    }

    public static class BeforeExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=1, readOnly=false) Runnable runnable) {
            if (runnable instanceof ContextPropagatingRunnable) {
                runnable = ((ContextPropagatingRunnable)runnable).unwrap();
            }
        }
    }
}

