/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.grizzly;

import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.bootstrap.servlet.AppServerBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyErrorHolder;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlySingletons;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyStateStorage;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;

public class DefaultFilterChainInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.glassfish.grizzly.filterchain.DefaultFilterChain");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPrivate()).and((ElementMatcher)ElementMatchers.named((String)"notifyFailure")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.filterchain.FilterChainContext"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, Throwable.class)), DefaultFilterChainInstrumentation.class.getName() + "$NotifyFailureAdvice");
    }

    public static class NotifyFailureAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onFail(@Advice.Argument(value=0) FilterChainContext ctx, @Advice.Argument(value=1) Throwable throwable) {
            Context context = GrizzlyStateStorage.removeContext(ctx);
            HttpRequestPacket request = GrizzlyStateStorage.removeRequest(ctx);
            if (context != null && request != null) {
                Throwable error = GrizzlyErrorHolder.getOrDefault(context, throwable);
                if (error == null) {
                    error = AppServerBridge.getException((Context)context);
                }
                GrizzlySingletons.instrumenter().end(context, (Object)request, null, error);
            }
        }
    }
}

