/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.grizzly;

import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyStateStorage;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.glassfish.grizzly.filterchain.FilterChainContext;

public class FilterChainContextInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.glassfish.grizzly.filterchain.FilterChainContext");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"resume").and((ElementMatcher)ElementMatchers.takesArguments((int)0)), FilterChainContextInstrumentation.class.getName() + "$ResumeAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"write"), FilterChainContextInstrumentation.class.getName() + "$WriteAdvice");
    }

    public static class WriteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth = CallDepth.forClass(FilterChainContext.class);
            callDepth.getAndIncrement();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.This FilterChainContext filterChainContext, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            if (callDepth.decrementAndGet() == 0) {
                GrizzlyStateStorage.removeContext(filterChainContext);
                GrizzlyStateStorage.removeRequest(filterChainContext);
            }
        }
    }

    public static class ResumeAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope onEnter() {
            return Java8BytecodeBridge.rootContext().makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Enter Scope scope) {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

