/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.grizzly;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyStateStorage;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;

public class FilterInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.glassfish.grizzly.filterchain.BaseFilter"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.hasSuperClass((ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.filterchain.BaseFilter")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpCodecFilter"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpServerFilter")));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"handleRead").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.filterchain.FilterChainContext"))).and((ElementMatcher)ElementMatchers.isPublic()), FilterInstrumentation.class.getName() + "$HandleReadAdvice");
    }

    public static class HandleReadAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.This BaseFilter it, @Advice.Argument(value=0) FilterChainContext ctx, @Advice.Local(value="otelScope") Scope scope) {
            if (Java8BytecodeBridge.currentSpan().getSpanContext().isValid()) {
                return;
            }
            Context context = GrizzlyStateStorage.getContext(ctx);
            if (context != null) {
                scope = context.makeCurrent();
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.This BaseFilter it, @Advice.Local(value="otelScope") Scope scope) {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

