/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.grizzly;

import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;

final class GrizzlyHttpAttributesGetter
implements HttpServerAttributesGetter<HttpRequestPacket, HttpResponsePacket> {
    GrizzlyHttpAttributesGetter() {
    }

    public String getHttpRequestMethod(HttpRequestPacket request) {
        return request.getMethod().getMethodString();
    }

    public List<String> getHttpRequestHeader(HttpRequestPacket request, String name) {
        return GrizzlyHttpAttributesGetter.toHeaderList(request.getHeaders().values(name));
    }

    private static List<String> toHeaderList(Iterable<String> values) {
        if (values.iterator().hasNext()) {
            ArrayList<String> result = new ArrayList<String>();
            values.forEach(result::add);
            return result;
        }
        return Collections.emptyList();
    }

    public Integer getHttpResponseStatusCode(HttpRequestPacket request, HttpResponsePacket response, @Nullable Throwable error) {
        return response.getStatus();
    }

    public List<String> getHttpResponseHeader(HttpRequestPacket request, HttpResponsePacket response, String name) {
        return GrizzlyHttpAttributesGetter.toHeaderList(response.getHeaders().values(name));
    }

    public String getUrlScheme(HttpRequestPacket request) {
        return request.isSecure() ? "https" : "http";
    }

    @Nullable
    public String getUrlPath(HttpRequestPacket request) {
        return request.getRequestURI();
    }

    @Nullable
    public String getUrlQuery(HttpRequestPacket request) {
        return request.getQueryString();
    }

    @Nullable
    public String getNetworkTransport(HttpRequestPacket request, @Nullable HttpResponsePacket response) {
        Transport transport = request.getConnection().getTransport();
        if (transport instanceof TCPNIOTransport) {
            return "tcp";
        }
        if (transport instanceof UDPNIOTransport) {
            return "udp";
        }
        return null;
    }

    @Nullable
    public String getNetworkProtocolName(HttpRequestPacket request, @Nullable HttpResponsePacket response) {
        String protocol = request.getProtocolString();
        if (protocol.startsWith("HTTP/")) {
            return "http";
        }
        return null;
    }

    @Nullable
    public String getNetworkProtocolVersion(HttpRequestPacket request, @Nullable HttpResponsePacket response) {
        String protocol = request.getProtocolString();
        if (protocol.startsWith("HTTP/")) {
            return protocol.substring("HTTP/".length());
        }
        return null;
    }

    @Nullable
    public String getNetworkPeerAddress(HttpRequestPacket request, @Nullable HttpResponsePacket response) {
        return request.getRemoteAddress();
    }

    public Integer getNetworkPeerPort(HttpRequestPacket request, @Nullable HttpResponsePacket response) {
        return request.getRemotePort();
    }

    @Nullable
    public String getNetworkLocalAddress(HttpRequestPacket request, @Nullable HttpResponsePacket response) {
        return request.getLocalAddress();
    }

    public Integer getNetworkLocalPort(HttpRequestPacket request, @Nullable HttpResponsePacket response) {
        return request.getLocalPort();
    }
}

