/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.grizzly;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpServerExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import io.opentelemetry.javaagent.bootstrap.servlet.AppServerBridge;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyErrorHolder;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyHttpAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.grizzly.HttpRequestHeadersGetter;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;

public final class GrizzlySingletons {
    private static final Instrumenter<HttpRequestPacket, HttpResponsePacket> INSTRUMENTER;

    public static Instrumenter<HttpRequestPacket, HttpResponsePacket> instrumenter() {
        return INSTRUMENTER;
    }

    private GrizzlySingletons() {
    }

    static {
        GrizzlyHttpAttributesGetter httpAttributesGetter = new GrizzlyHttpAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)"io.opentelemetry.grizzly-2.3", (SpanNameExtractor)HttpSpanNameExtractor.builder((HttpServerAttributesGetter)httpAttributesGetter).setKnownMethods(CommonConfig.get().getKnownHttpRequestMethods()).build()).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor(HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)httpAttributesGetter).setCapturedRequestHeaders(CommonConfig.get().getServerRequestHeaders()).setCapturedResponseHeaders(CommonConfig.get().getServerResponseHeaders()).setKnownMethods(CommonConfig.get().getKnownHttpRequestMethods()).build()).addOperationMetrics(HttpServerMetrics.get());
        if (CommonConfig.get().shouldEmitExperimentalHttpServerTelemetry()) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpServerExperimentalMetrics.get());
        }
        INSTRUMENTER = builder.addContextCustomizer((context, request, attributes) -> new AppServerBridge.Builder().captureServletAttributes().recordException().init(context)).addContextCustomizer((context, httpRequestPacket, startAttributes) -> GrizzlyErrorHolder.init(context)).addContextCustomizer(HttpServerRoute.builder((HttpServerAttributesGetter)httpAttributesGetter).setKnownMethods(CommonConfig.get().getKnownHttpRequestMethods()).build()).buildServerInstrumenter((TextMapGetter)HttpRequestHeadersGetter.INSTANCE);
    }
}

