/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.grizzly;

import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlySingletons;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyStateStorage;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;

public class HttpCodecFilterInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpCodecFilter");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"handleRead").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.filterchain.FilterChainContext"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpHeader").or((ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpPacketParsing")))).and((ElementMatcher)ElementMatchers.isPublic()), HttpCodecFilterInstrumentation.class.getName() + "$HandleReadAdvice");
    }

    public static class HandleReadAdvice {
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Argument(value=0) FilterChainContext ctx, @Advice.Argument(value=1) Object httpHeader) {
            Context parentContext = GrizzlyStateStorage.getContext(ctx);
            if (parentContext == null) {
                parentContext = Java8BytecodeBridge.currentContext();
            }
            if (!(httpHeader instanceof HttpRequestPacket)) {
                return;
            }
            HttpRequestPacket httpRequest = (HttpRequestPacket)httpHeader;
            if (!GrizzlySingletons.instrumenter().shouldStart(parentContext, (Object)httpRequest)) {
                return;
            }
            Context context = GrizzlySingletons.instrumenter().start(parentContext, (Object)httpRequest);
            GrizzlyStateStorage.attachContextAndRequest(ctx, context, httpRequest);
        }
    }
}

