/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.grizzly;

import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyErrorHolder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class HttpHandlerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.glassfish.grizzly.http.server.HttpHandler"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.server.HttpHandler"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.named((String)"service")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.server.Request"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.server.Response"))), HttpHandlerInstrumentation.class.getName() + "$ServiceAdvice");
    }

    public static class ServiceAdvice {
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable) {
            if (throwable != null) {
                GrizzlyErrorHolder.set(Java8BytecodeBridge.currentContext(), throwable);
            }
        }
    }
}

