/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.grizzly;

import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseCustomizerHolder;
import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseMutator;
import io.opentelemetry.javaagent.bootstrap.servlet.AppServerBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyErrorHolder;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyHttpResponseMutator;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlySingletons;
import io.opentelemetry.javaagent.instrumentation.grizzly.GrizzlyStateStorage;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;

public class HttpServerFilterInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpServerFilter");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"prepareResponse").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.filterchain.FilterChainContext"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpRequestPacket"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpResponsePacket"))).and((ElementMatcher)ElementMatchers.takesArgument((int)3, (ElementMatcher)ElementMatchers.named((String)"org.glassfish.grizzly.http.HttpContent"))).and((ElementMatcher)ElementMatchers.isPrivate()), HttpServerFilterInstrumentation.class.getName() + "$PrepareResponseAdvice");
    }

    public static class PrepareResponseAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) FilterChainContext ctx, @Advice.Argument(value=2) HttpResponsePacket response) {
            Context context = GrizzlyStateStorage.getContext(ctx);
            HttpServerResponseCustomizerHolder.getCustomizer().customize(context, (Object)response, (HttpServerResponseMutator)GrizzlyHttpResponseMutator.INSTANCE);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Argument(value=0) FilterChainContext ctx, @Advice.Argument(value=2) HttpResponsePacket response) {
            Context context = GrizzlyStateStorage.removeContext(ctx);
            HttpRequestPacket request = GrizzlyStateStorage.removeRequest(ctx);
            if (context != null && request != null) {
                Throwable error = GrizzlyErrorHolder.getOrDefault(context, null);
                if (error == null) {
                    error = AppServerBridge.getException((Context)context);
                }
                GrizzlySingletons.instrumenter().end(context, (Object)request, (Object)response, error);
            }
        }
    }
}

