/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.metro;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.instrumentation.metro.MetroRequest;
import io.opentelemetry.javaagent.instrumentation.metro.MetroServerSpanNaming;
import io.opentelemetry.javaagent.instrumentation.metro.MetroSingletons;

public final class MetroHelper {
    private static final String REQUEST_KEY = MetroHelper.class.getName() + ".Request";
    private static final String CONTEXT_KEY = MetroHelper.class.getName() + ".Context";
    private static final String SCOPE_KEY = MetroHelper.class.getName() + ".Scope";
    private static final String THROWABLE_KEY = MetroHelper.class.getName() + ".Throwable";

    private MetroHelper() {
    }

    public static void start(WSEndpoint<?> endpoint, Packet packet) {
        Context parentContext = Context.current();
        MetroRequest request = new MetroRequest(endpoint, packet);
        MetroServerSpanNaming.updateServerSpanName(parentContext, request);
        if (!MetroSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
            return;
        }
        Context context = MetroSingletons.instrumenter().start(parentContext, (Object)request);
        Scope scope = context.makeCurrent();
        packet.invocationProperties.put(REQUEST_KEY, request);
        packet.invocationProperties.put(CONTEXT_KEY, context);
        packet.invocationProperties.put(SCOPE_KEY, scope);
    }

    public static void end(Packet packet) {
        MetroHelper.end(packet, null);
    }

    public static void end(Packet packet, Throwable throwable) {
        Scope scope = (Scope)packet.invocationProperties.remove(SCOPE_KEY);
        if (scope == null) {
            return;
        }
        scope.close();
        MetroRequest request = (MetroRequest)packet.invocationProperties.remove(REQUEST_KEY);
        Context context = (Context)packet.invocationProperties.remove(CONTEXT_KEY);
        if (throwable == null) {
            throwable = (Throwable)packet.invocationProperties.remove(THROWABLE_KEY);
        }
        MetroSingletons.instrumenter().end(context, (Object)request, null, throwable);
    }

    public static void storeThrowable(Packet packet, Throwable throwable) {
        packet.invocationProperties.put(THROWABLE_KEY, throwable);
    }
}

