/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.metro;

import com.sun.xml.ws.api.message.Packet;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.bootstrap.servlet.ServletContextPath;
import io.opentelemetry.javaagent.instrumentation.metro.MetroRequest;
import javax.servlet.http.HttpServletRequest;

public final class MetroServerSpanNaming {
    public static void updateServerSpanName(Context context, MetroRequest metroRequest) {
        HttpServletRequest httpRequest;
        String servletPath;
        Object request;
        String spanName = metroRequest.spanName();
        if (spanName == null) {
            return;
        }
        Span serverSpan = LocalRootSpan.fromContextOrNull((Context)context);
        if (serverSpan == null) {
            return;
        }
        Packet packet = metroRequest.packet();
        if (packet.supports((Object)"javax.xml.ws.servlet.request") && (request = packet.get((Object)"javax.xml.ws.servlet.request")) instanceof HttpServletRequest && !(servletPath = (httpRequest = (HttpServletRequest)request).getServletPath()).isEmpty()) {
            String pathInfo = httpRequest.getPathInfo();
            if (pathInfo != null) {
                spanName = servletPath + "/" + spanName;
            } else {
                String operationName = packet.getWSDLOperation().getLocalPart();
                spanName = servletPath + "/" + operationName;
            }
        }
        serverSpan.updateName(ServletContextPath.prepend((Context)context, (String)spanName));
    }

    private MetroServerSpanNaming() {
    }
}

