/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.metro;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.metro.MetroHelper;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class SoapFaultBuilderInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"com.sun.xml.ws.fault.SOAPFaultBuilder");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"createSOAPFaultMessage").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.sun.xml.ws.api.SOAPVersion"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"com.sun.xml.ws.model.CheckedExceptionImpl"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)Throwable.class.getName()))), SoapFaultBuilderInstrumentation.class.getName() + "$CaptureThrowableAdvice");
    }

    public static class CaptureThrowableAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=2) Throwable throwable) {
            if (throwable == null) {
                return;
            }
            Packet request = null;
            try {
                request = Fiber.current().getPacket();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (request != null) {
                MetroHelper.storeThrowable(request, throwable);
            }
        }
    }
}

