/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.metro;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import io.opentelemetry.javaagent.instrumentation.metro.MetroHelper;

public class TracingTube
extends AbstractFilterTubeImpl {
    private final WSEndpoint<?> endpoint;

    public TracingTube(WSEndpoint<?> endpoint, Tube next) {
        super(next);
        this.endpoint = endpoint;
    }

    public TracingTube(TracingTube that, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)that, tubeCloner);
        this.endpoint = that.endpoint;
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new TracingTube(this, tubeCloner);
    }

    public NextAction processRequest(Packet request) {
        MetroHelper.start(this.endpoint, request);
        return super.processRequest(request);
    }

    public NextAction processResponse(Packet response) {
        MetroHelper.end(response);
        return super.processResponse(response);
    }

    public NextAction processException(Throwable throwable) {
        Packet request = null;
        try {
            request = Fiber.current().getPacket();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (request != null) {
            MetroHelper.end(request, throwable);
        }
        return super.processException(throwable);
    }
}

