/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javaagent.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.incubator.logs.ExtendedLogRecordBuilder;
import io.opentelemetry.instrumentation.javaagent.runtimemetrics.java8.JarDetails;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.internal.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class JarAnalyzer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(JarAnalyzer.class.getName());
    private static final String EVENT_NAME_INFO = "package.info";
    static final AttributeKey<String> PACKAGE_NAME = AttributeKey.stringKey((String)"package.name");
    static final AttributeKey<String> PACKAGE_VERSION = AttributeKey.stringKey((String)"package.version");
    static final AttributeKey<String> PACKAGE_TYPE = AttributeKey.stringKey((String)"package.type");
    static final AttributeKey<String> PACKAGE_DESCRIPTION = AttributeKey.stringKey((String)"package.description");
    static final AttributeKey<String> PACKAGE_CHECKSUM = AttributeKey.stringKey((String)"package.checksum");
    static final AttributeKey<String> PACKAGE_CHECKSUM_ALGORITHM = AttributeKey.stringKey((String)"package.checksum_algorithm");
    static final AttributeKey<String> PACKAGE_PATH = AttributeKey.stringKey((String)"package.path");
    private final Set<URI> seenUris = new HashSet<URI>();
    private final BlockingQueue<URL> toProcess = new LinkedBlockingDeque<URL>();

    private JarAnalyzer(OpenTelemetry openTelemetry, int jarsPerSecond) {
        ExtendedLogRecordBuilder logRecordBuilder = (ExtendedLogRecordBuilder)openTelemetry.getLogsBridge().loggerBuilder(JmxRuntimeMetricsUtil.getInstrumentationName()).setInstrumentationVersion(JmxRuntimeMetricsUtil.getInstrumentationVersion()).build().logRecordBuilder();
        Worker worker = new Worker(logRecordBuilder, this.toProcess, jarsPerSecond);
        Thread workerThread = new DaemonThreadFactory(JarAnalyzer.class.getSimpleName() + "_WorkerThread").newThread((Runnable)worker);
        workerThread.start();
    }

    public static JarAnalyzer create(OpenTelemetry unused, int jarsPerSecond) {
        return new JarAnalyzer(unused, jarsPerSecond);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        this.handle(protectionDomain);
        return null;
    }

    private void handle(ProtectionDomain protectionDomain) {
        URI locationUri;
        if (protectionDomain == null) {
            return;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return;
        }
        URL archiveUrl = codeSource.getLocation();
        if (archiveUrl == null) {
            return;
        }
        try {
            locationUri = archiveUrl.toURI();
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "Unable to get URI for code location URL: " + archiveUrl, e);
            return;
        }
        if (!this.seenUris.add(locationUri)) {
            return;
        }
        if ("jrt".equals(archiveUrl.getProtocol())) {
            logger.log(Level.FINEST, "Skipping processing for java runtime module: {0}", archiveUrl);
            return;
        }
        String file = archiveUrl.getFile();
        if (file.endsWith("/")) {
            logger.log(Level.FINEST, "Skipping processing non-archive code location: {0}", archiveUrl);
            return;
        }
        if (!(file.endsWith("jar") || file.endsWith("war") || file.endsWith("ear"))) {
            logger.log(Level.INFO, "Skipping processing unrecognized code location: {0}", archiveUrl);
            return;
        }
        if ("file".equals(archiveUrl.getProtocol())) {
            try {
                File archiveFile = new File(archiveUrl.toURI().getSchemeSpecificPart());
                if (archiveFile.exists() && archiveFile.isFile()) {
                    archiveUrl = archiveFile.toURI().toURL();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to normalize location URL: " + archiveUrl, e);
            }
        }
        this.toProcess.add(archiveUrl);
    }

    static void processUrl(ExtendedLogRecordBuilder eventLogger, URL archiveUrl) {
        String packageDescription;
        String packageVersion;
        String packageName;
        String packageType;
        JarDetails jarDetails;
        try {
            jarDetails = JarDetails.forUrl(archiveUrl);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error reading package for archive URL: " + archiveUrl, e);
            return;
        }
        AttributesBuilder builder = Attributes.builder();
        String packagePath = jarDetails.packagePath();
        if (packagePath != null) {
            builder.put(PACKAGE_PATH, (Object)packagePath);
        }
        if ((packageType = jarDetails.packageType()) != null) {
            builder.put(PACKAGE_TYPE, (Object)packageType);
        }
        if ((packageName = jarDetails.packageName()) != null) {
            builder.put(PACKAGE_NAME, (Object)packageName);
        }
        if ((packageVersion = jarDetails.version()) != null) {
            builder.put(PACKAGE_VERSION, (Object)packageVersion);
        }
        if ((packageDescription = jarDetails.packageDescription()) != null) {
            builder.put(PACKAGE_DESCRIPTION, (Object)packageDescription);
        }
        String packageChecksum = jarDetails.computeSha1();
        builder.put(PACKAGE_CHECKSUM, (Object)packageChecksum);
        builder.put(PACKAGE_CHECKSUM_ALGORITHM, (Object)"SHA1");
        eventLogger.setEventName(EVENT_NAME_INFO).setAllAttributes(builder.build()).emit();
    }

    private static final class Worker
    implements Runnable {
        private final ExtendedLogRecordBuilder eventLogger;
        private final BlockingQueue<URL> toProcess;
        private final RateLimiter rateLimiter;

        private Worker(ExtendedLogRecordBuilder eventLogger, BlockingQueue<URL> toProcess, int jarsPerSecond) {
            this.eventLogger = eventLogger;
            this.toProcess = toProcess;
            this.rateLimiter = new RateLimiter((double)jarsPerSecond, (double)jarsPerSecond, Clock.getDefault());
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                URL archiveUrl = null;
                try {
                    if (!this.rateLimiter.trySpend(1.0)) {
                        Thread.sleep(100L);
                        continue;
                    }
                    archiveUrl = this.toProcess.poll(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (archiveUrl == null) continue;
                try {
                    JarAnalyzer.processUrl(this.eventLogger, archiveUrl);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Unexpected error processing archive URL: " + archiveUrl, e);
                }
            }
            logger.warning("JarAnalyzer stopped");
        }
    }
}

