/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javaagent.runtimemetrics.java8;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.javaagent.runtimemetrics.java8.JarAnalyzer;
import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import io.opentelemetry.javaagent.tooling.BeforeAgentListener;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.lang.instrument.Instrumentation;

@AutoService(value={BeforeAgentListener.class})
public class JarAnalyzerInstaller
implements BeforeAgentListener {
    public void beforeAgent(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
        ConfigProperties config = AutoConfigureUtil.getConfig((AutoConfiguredOpenTelemetrySdk)autoConfiguredOpenTelemetrySdk);
        boolean enabled = config.getBoolean("otel.instrumentation.runtime-telemetry.package-emitter.enabled", false);
        if (!enabled) {
            return;
        }
        Instrumentation inst = InstrumentationHolder.getInstrumentation();
        if (inst == null) {
            return;
        }
        int jarsPerSecond = config.getInt("otel.instrumentation.runtime-telemetry.package-emitter.jars-per-second", 10);
        JarAnalyzer jarAnalyzer = JarAnalyzer.create((OpenTelemetry)autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk(), jarsPerSecond);
        inst.addTransformer(jarAnalyzer);
    }
}

