/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javaagent.runtimemetrics.java8;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class JarDetails {
    static final String JAR_EXTENSION = "jar";
    static final String WAR_EXTENSION = "war";
    static final String EAR_EXTENSION = "ear";
    private static final Map<String, String> EMBEDDED_FORMAT_TO_EXTENSION = Stream.of("jar", "war", "ear").collect(Collectors.collectingAndThen(Collectors.toMap(ext -> '.' + ext + "!/", Function.identity()), Collections::unmodifiableMap));
    private static final ThreadLocal<MessageDigest> SHA1 = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    });
    private final URL url;
    protected final JarFile jarFile;
    private final Properties pom;
    private final Manifest manifest;
    private final String sha1Checksum;

    private JarDetails(URL url, JarFile jarFile) throws IOException {
        this.url = url;
        this.jarFile = jarFile;
        this.pom = this.getPom();
        this.manifest = this.getManifest();
        this.sha1Checksum = this.computeDigest(SHA1.get());
    }

    static JarDetails forUrl(URL url) throws IOException {
        if (url.getProtocol().equals(JAR_EXTENSION)) {
            String urlString = url.toExternalForm();
            String urlLower = urlString.toLowerCase(Locale.ROOT);
            for (Map.Entry<String, String> entry : EMBEDDED_FORMAT_TO_EXTENSION.entrySet()) {
                int index = urlLower.indexOf(entry.getKey());
                if (index <= 0) continue;
                String targetEntry = urlString.substring(index + entry.getKey().length());
                JarFile jarFile = new JarFile(urlString.substring("jar:file:".length(), index + 1 + entry.getValue().length()));
                JarEntry jarEntry = jarFile.getJarEntry(targetEntry);
                return new EmbeddedJarDetails(url, jarFile, jarEntry);
            }
        }
        return new JarDetails(url, new JarFile(url.getFile()));
    }

    @Nullable
    String packagePath() {
        String path = this.url.getFile();
        int start = path.lastIndexOf(File.separator);
        if (start > -1) {
            return path.substring(start + 1);
        }
        return null;
    }

    @Nullable
    String packageType() {
        String path = this.url.getFile();
        int extensionStart = path.lastIndexOf(".");
        if (extensionStart > -1) {
            return path.substring(extensionStart + 1);
        }
        return null;
    }

    @Nullable
    String packageName() {
        if (this.pom == null) {
            return null;
        }
        String groupId = this.pom.getProperty("groupId");
        String artifactId = this.pom.getProperty("artifactId");
        if (groupId != null && !groupId.isEmpty() && artifactId != null && !artifactId.isEmpty()) {
            return groupId + ":" + artifactId;
        }
        return null;
    }

    @Nullable
    String version() {
        if (this.pom == null) {
            return null;
        }
        String version = this.pom.getProperty("version");
        if (version != null && !version.isEmpty()) {
            return version;
        }
        return null;
    }

    @Nullable
    String packageDescription() {
        if (this.manifest == null) {
            return null;
        }
        Attributes mainAttributes = this.manifest.getMainAttributes();
        String name = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String description = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        String packageDescription = name;
        if (description != null && !description.isEmpty()) {
            packageDescription = packageDescription + " by " + description;
        }
        return packageDescription;
    }

    String computeSha1() {
        return this.sha1Checksum;
    }

    private String computeDigest(MessageDigest md) throws IOException {
        try (InputStream inputStream = this.getInputStream();){
            DigestInputStream dis = new DigestInputStream(inputStream, md);
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
            byte[] digest = md.digest();
            String string = new BigInteger(1, digest).toString(16);
            return string;
        }
    }

    protected InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    @Nullable
    protected Manifest getManifest() {
        try {
            return this.jarFile.getManifest();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    protected Properties getPom() throws IOException {
        Properties pom = null;
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().startsWith("META-INF/maven") || !jarEntry.getName().endsWith("pom.properties")) continue;
            if (pom != null) {
                return null;
            }
            Properties props = new Properties();
            InputStream in = this.jarFile.getInputStream(jarEntry);
            try {
                props.load(in);
                pom = props;
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        return pom;
    }

    private static class EmbeddedJarDetails
    extends JarDetails {
        private final JarEntry jarEntry;

        private EmbeddedJarDetails(URL url, JarFile jarFile, JarEntry jarEntry) throws IOException {
            super(url, jarFile);
            this.jarEntry = jarEntry;
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.jarEntry);
        }

        @Override
        protected Manifest getManifest() {
            Manifest manifest;
            JarInputStream jarFile = new JarInputStream(this.getInputStream());
            try {
                manifest = jarFile.getManifest();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            jarFile.close();
            return manifest;
        }

        @Override
        @Nullable
        protected Properties getPom() throws IOException {
            Properties pom = null;
            try (JarInputStream jarFile = new JarInputStream(this.getInputStream());){
                JarEntry entry = jarFile.getNextJarEntry();
                while (entry != null) {
                    if (entry.getName().startsWith("META-INF/maven") && entry.getName().endsWith("pom.properties")) {
                        if (pom != null) {
                            Properties properties = null;
                            return properties;
                        }
                        Properties props = new Properties();
                        props.load(jarFile);
                        pom = props;
                    }
                    entry = jarFile.getNextJarEntry();
                }
                Properties properties = pom;
                return properties;
            }
        }
    }
}

