/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javaagent.runtimemetrics.java8;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.instrumentation.runtimemetrics.java8.RuntimeMetrics;
import io.opentelemetry.instrumentation.runtimemetrics.java8.RuntimeMetricsBuilder;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.RuntimeMetricsConfigUtil;
import io.opentelemetry.javaagent.bootstrap.internal.AgentInstrumentationConfig;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;

@AutoService(value={AgentListener.class})
public class Java8RuntimeMetricsInstaller
implements AgentListener {
    public void afterAgent(AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
        if (Double.parseDouble(System.getProperty("java.specification.version")) >= 17.0) {
            return;
        }
        RuntimeMetrics runtimeMetrics = RuntimeMetricsConfigUtil.configure((RuntimeMetricsBuilder)RuntimeMetrics.builder((OpenTelemetry)GlobalOpenTelemetry.get()), (InstrumentationConfig)AgentInstrumentationConfig.get());
        if (runtimeMetrics != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((RuntimeMetrics)runtimeMetrics).close(), "OpenTelemetry RuntimeMetricsShutdownHook"));
        }
    }
}

