/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletHelper;

public class AsyncRunnableWrapper<REQUEST>
implements Runnable {
    private final ServletHelper<REQUEST, ?> helper;
    private final Runnable runnable;
    private final Context context;

    private AsyncRunnableWrapper(ServletHelper<REQUEST, ?> helper, Runnable runnable) {
        this.helper = helper;
        this.runnable = runnable;
        this.context = Context.current();
    }

    public static <REQUEST> Runnable wrap(ServletHelper<REQUEST, ?> helper, Runnable runnable) {
        if (runnable == null || runnable instanceof AsyncRunnableWrapper) {
            return runnable;
        }
        return new AsyncRunnableWrapper<REQUEST>(helper, runnable);
    }

    @Override
    public void run() {
        try {
            this.runnable.run();
        }
        catch (Throwable throwable) {
            this.helper.recordAsyncException(this.context, throwable);
            throw throwable;
        }
    }
}

