/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRouteSource;
import io.opentelemetry.javaagent.bootstrap.internal.AgentCommonConfig;
import io.opentelemetry.javaagent.bootstrap.servlet.AppServerBridge;
import io.opentelemetry.javaagent.bootstrap.servlet.MappingResolver;
import io.opentelemetry.javaagent.bootstrap.servlet.ServletAsyncContext;
import io.opentelemetry.javaagent.bootstrap.servlet.ServletContextPath;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletHelper;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestParametersExtractor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletSpanNameProvider;
import io.opentelemetry.semconv.incubating.EnduserIncubatingAttributes;
import java.security.Principal;
import java.util.function.Function;

public abstract class BaseServletHelper<REQUEST, RESPONSE> {
    protected final Instrumenter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> instrumenter;
    protected final ServletAccessor<REQUEST, RESPONSE> accessor;
    private final ServletSpanNameProvider<REQUEST> spanNameProvider;
    private final Function<REQUEST, String> contextPathExtractor;
    private final ServletRequestParametersExtractor<REQUEST, RESPONSE> parameterExtractor;

    protected BaseServletHelper(Instrumenter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> instrumenter, ServletAccessor<REQUEST, RESPONSE> accessor) {
        this.instrumenter = instrumenter;
        this.accessor = accessor;
        this.spanNameProvider = new ServletSpanNameProvider<REQUEST>(accessor);
        this.contextPathExtractor = accessor::getRequestContextPath;
        this.parameterExtractor = ServletRequestParametersExtractor.enabled() ? new ServletRequestParametersExtractor<REQUEST, RESPONSE>(accessor) : null;
    }

    public boolean shouldStart(Context parentContext, ServletRequestContext<REQUEST> requestContext) {
        return this.instrumenter.shouldStart(parentContext, requestContext);
    }

    public Context start(Context parentContext, ServletRequestContext<REQUEST> requestContext) {
        Context context = this.instrumenter.start(parentContext, requestContext);
        REQUEST request = requestContext.request();
        SpanContext spanContext = Span.fromContext((Context)context).getSpanContext();
        this.accessor.setRequestAttribute(request, "trace_id", spanContext.getTraceId());
        this.accessor.setRequestAttribute(request, "span_id", spanContext.getSpanId());
        context = this.addServletContextPath(context, request);
        context = this.addAsyncContext(context);
        this.attachServerContext(context, request);
        return context;
    }

    protected Context addServletContextPath(Context context, REQUEST request) {
        return ServletContextPath.init((Context)context, this.contextPathExtractor, request);
    }

    protected Context addAsyncContext(Context context) {
        return ServletAsyncContext.init((Context)context);
    }

    public Context getServerContext(REQUEST request) {
        Object context = this.accessor.getRequestAttribute(request, ServletHelper.CONTEXT_ATTRIBUTE);
        return context instanceof Context ? (Context)context : null;
    }

    private void attachServerContext(Context context, REQUEST request) {
        this.accessor.setRequestAttribute(request, ServletHelper.CONTEXT_ATTRIBUTE, context);
    }

    public void recordException(Context context, Throwable throwable) {
        AppServerBridge.recordException((Context)context, (Throwable)throwable);
    }

    public Context updateContext(Context context, REQUEST request, MappingResolver mappingResolver, boolean servlet) {
        Context result = this.addServletContextPath(context, request);
        result = this.addAsyncContext(result);
        if (mappingResolver != null) {
            HttpServerRoute.update((Context)result, (HttpServerRouteSource)(servlet ? HttpServerRouteSource.SERVER : HttpServerRouteSource.SERVER_FILTER), this.spanNameProvider, (Object)mappingResolver, request);
        }
        return result;
    }

    public void captureServletAttributes(Context context, REQUEST request) {
        if (!AppServerBridge.captureServletAttributes((Context)context)) {
            return;
        }
        Span serverSpan = LocalRootSpan.fromContextOrNull((Context)context);
        if (serverSpan == null) {
            return;
        }
        this.captureRequestParameters(serverSpan, request);
        this.captureEnduserId(serverSpan, request);
    }

    private void captureRequestParameters(Span serverSpan, REQUEST request) {
        if (this.parameterExtractor == null) {
            return;
        }
        this.parameterExtractor.setAttributes(request, (arg_0, arg_1) -> ((Span)serverSpan).setAttribute(arg_0, arg_1));
    }

    private void captureEnduserId(Span serverSpan, REQUEST request) {
        String name;
        if (!AgentCommonConfig.get().getEnduserConfig().isIdEnabled()) {
            return;
        }
        Principal principal = this.accessor.getRequestUserPrincipal(request);
        if (principal != null && (name = principal.getName()) != null) {
            serverSpan.setAttribute(EnduserIncubatingAttributes.ENDUSER_ID, (Object)name);
        }
    }

    public boolean needsRescoping(Context currentContext, Context attachedContext) {
        return !BaseServletHelper.sameTrace(Span.fromContext((Context)currentContext), Span.fromContext((Context)attachedContext));
    }

    private static boolean sameTrace(Span oneSpan, Span otherSpan) {
        return oneSpan.getSpanContext().getTraceId().equals(otherSpan.getSpanContext().getTraceId());
    }
}

