/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.bootstrap.internal.AgentCommonConfig;
import io.opentelemetry.javaagent.bootstrap.internal.AgentInstrumentationConfig;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext;
import io.opentelemetry.semconv.incubating.EnduserIncubatingAttributes;
import java.security.Principal;
import javax.annotation.Nullable;

public class ServletAdditionalAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> {
    private static final boolean CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES = AgentInstrumentationConfig.get().getBoolean("otel.instrumentation.servlet.experimental-span-attributes", false);
    private static final AttributeKey<Long> SERVLET_TIMEOUT = AttributeKey.longKey((String)"servlet.timeout");
    private final ServletAccessor<REQUEST, RESPONSE> accessor;

    public ServletAdditionalAttributesExtractor(ServletAccessor<REQUEST, RESPONSE> accessor) {
        this.accessor = accessor;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, ServletRequestContext<REQUEST> requestContext) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, ServletRequestContext<REQUEST> requestContext, @Nullable ServletResponseContext<RESPONSE> responseContext, @Nullable Throwable error) {
        String name;
        Principal principal;
        if (AgentCommonConfig.get().getEnduserConfig().isIdEnabled() && (principal = this.accessor.getRequestUserPrincipal(requestContext.request())) != null && (name = principal.getName()) != null) {
            attributes.put(EnduserIncubatingAttributes.ENDUSER_ID, (Object)name);
        }
        if (!CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES) {
            return;
        }
        if (responseContext != null && responseContext.hasTimeout()) {
            attributes.put(SERVLET_TIMEOUT, (Object)responseContext.getTimeout());
        }
    }
}

