/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.bootstrap.servlet.ServletAsyncContext;
import io.opentelemetry.javaagent.instrumentation.servlet.AsyncRequestCompletionListener;
import io.opentelemetry.javaagent.instrumentation.servlet.AsyncRunnableWrapper;
import io.opentelemetry.javaagent.instrumentation.servlet.BaseServletHelper;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext;

public class ServletHelper<REQUEST, RESPONSE>
extends BaseServletHelper<REQUEST, RESPONSE> {
    public static final String CONTEXT_ATTRIBUTE = ServletHelper.class.getName() + ".Context";

    public ServletHelper(Instrumenter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> instrumenter, ServletAccessor<REQUEST, RESPONSE> accessor) {
        super(instrumenter, accessor);
    }

    public void end(ServletRequestContext<REQUEST> requestContext, REQUEST request, RESPONSE response, Throwable throwable, boolean topLevel, Context context, Scope scope) {
        if (scope != null) {
            scope.close();
        }
        if (context == null && topLevel) {
            Context currentContext = Context.current();
            if (throwable != null) {
                this.recordException(currentContext, throwable);
                if (!this.mustEndOnHandlerMethodExit(currentContext)) {
                    this.recordAsyncException(currentContext, throwable);
                }
            }
            this.captureServletAttributes(currentContext, request);
        }
        if (scope == null || context == null) {
            return;
        }
        ServletResponseContext<RESPONSE> responseContext = new ServletResponseContext<RESPONSE>(response);
        if (throwable != null || this.mustEndOnHandlerMethodExit(context)) {
            this.instrumenter.end(context, requestContext, responseContext, throwable);
        }
    }

    public boolean mustEndOnHandlerMethodExit(Context context) {
        return !ServletHelper.isAsyncListenerAttached(context);
    }

    public void setAsyncListenerResponse(Context context, RESPONSE response) {
        ServletAsyncContext.setAsyncListenerResponse((Context)context, response);
    }

    public RESPONSE getAsyncListenerResponse(Context context) {
        return (RESPONSE)ServletAsyncContext.getAsyncListenerResponse((Context)context);
    }

    public void attachAsyncListener(REQUEST request, Context context) {
        if (ServletHelper.isAsyncListenerAttached(context)) {
            return;
        }
        RESPONSE response = this.getAsyncListenerResponse(context);
        ServletRequestContext<REQUEST> requestContext = new ServletRequestContext<REQUEST>(request, null);
        this.accessor.addRequestAsyncListener(request, new AsyncRequestCompletionListener(this, this.instrumenter, requestContext, context), response);
        ServletAsyncContext.setAsyncListenerAttached((Context)context, (boolean)true);
    }

    private static boolean isAsyncListenerAttached(Context context) {
        return ServletAsyncContext.isAsyncListenerAttached((Context)context);
    }

    public Runnable wrapAsyncRunnable(Runnable runnable) {
        return AsyncRunnableWrapper.wrap(this, runnable);
    }

    public void recordAsyncException(Context context, Throwable throwable) {
        ServletAsyncContext.recordAsyncException((Context)context, (Throwable)throwable);
    }

    public Throwable getAsyncException(Context context) {
        return ServletAsyncContext.getAsyncException((Context)context);
    }

    public Context getAsyncListenerContext(Context context) {
        return ServletAsyncContext.getAsyncListenerContext((Context)context);
    }
}

