/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpServerInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.javaagent.bootstrap.internal.AgentCommonConfig;
import io.opentelemetry.javaagent.bootstrap.internal.JavaagentHttpServerInstrumenters;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAdditionalAttributesExtractor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletErrorCauseExtractor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletHttpAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestGetter;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestParametersExtractor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext;
import java.util.ArrayList;
import java.util.List;

public final class ServletInstrumenterBuilder<REQUEST, RESPONSE> {
    private final List<ContextCustomizer<? super ServletRequestContext<REQUEST>>> contextCustomizers = new ArrayList<ContextCustomizer<? super ServletRequestContext<REQUEST>>>();
    private boolean propagateOperationListenersToOnEnd;

    private ServletInstrumenterBuilder() {
    }

    public static <REQUEST, RESPONSE> ServletInstrumenterBuilder<REQUEST, RESPONSE> create() {
        return new ServletInstrumenterBuilder<REQUEST, RESPONSE>();
    }

    @CanIgnoreReturnValue
    public ServletInstrumenterBuilder<REQUEST, RESPONSE> addContextCustomizer(ContextCustomizer<? super ServletRequestContext<REQUEST>> contextCustomizer) {
        this.contextCustomizers.add(contextCustomizer);
        return this;
    }

    @CanIgnoreReturnValue
    public ServletInstrumenterBuilder<REQUEST, RESPONSE> propagateOperationListenersToOnEnd() {
        this.propagateOperationListenersToOnEnd = true;
        return this;
    }

    public Instrumenter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> build(String instrumentationName, ServletAccessor<REQUEST, RESPONSE> accessor, SpanNameExtractor<ServletRequestContext<REQUEST>> spanNameExtractor, HttpServerAttributesGetter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> httpAttributesGetter) {
        DefaultHttpServerInstrumenterBuilder serverBuilder = DefaultHttpServerInstrumenterBuilder.create((String)instrumentationName, (OpenTelemetry)GlobalOpenTelemetry.get(), httpAttributesGetter, new ServletRequestGetter<REQUEST>(accessor));
        serverBuilder.setSpanNameExtractor(e -> spanNameExtractor);
        return JavaagentHttpServerInstrumenters.create((DefaultHttpServerInstrumenterBuilder)serverBuilder, builder -> {
            if (ServletRequestParametersExtractor.enabled()) {
                ServletRequestParametersExtractor requestParametersExtractor = new ServletRequestParametersExtractor(accessor);
                builder.addAttributesExtractor(requestParametersExtractor);
            }
            for (ContextCustomizer<? super ServletRequestContext<REQUEST>> contextCustomizer : this.contextCustomizers) {
                builder.addContextCustomizer(contextCustomizer);
            }
            if (this.propagateOperationListenersToOnEnd) {
                InstrumenterUtil.propagateOperationListenersToOnEnd((InstrumenterBuilder)builder);
            }
            builder.addAttributesExtractor(new ServletAdditionalAttributesExtractor(accessor)).setErrorCauseExtractor(new ServletErrorCauseExtractor(accessor));
        });
    }

    public Instrumenter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> build(String instrumentationName, ServletAccessor<REQUEST, RESPONSE> accessor) {
        ServletHttpAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter = new ServletHttpAttributesGetter<REQUEST, RESPONSE>(accessor);
        SpanNameExtractor spanNameExtractor = HttpSpanNameExtractor.builder(httpAttributesGetter).setKnownMethods(AgentCommonConfig.get().getKnownHttpRequestMethods()).build();
        return this.build(instrumentationName, accessor, spanNameExtractor, httpAttributesGetter);
    }
}

