/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.snippet;

import io.opentelemetry.javaagent.bootstrap.servlet.InjectionState;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutputStreamSnippetInjectionHelper {
    private static final Logger logger = Logger.getLogger(OutputStreamSnippetInjectionHelper.class.getName());
    private final Supplier<String> snippetSupplier;

    public OutputStreamSnippetInjectionHelper(Supplier<String> snippetSupplier) {
        this.snippetSupplier = snippetSupplier;
    }

    public String getSnippet() {
        return this.snippetSupplier.get();
    }

    public boolean handleWrite(InjectionState state, OutputStream out, byte[] original, int off, int length) throws IOException {
        byte[] snippetBytes;
        int endOfHeadTagPosition;
        if (state.isHeadTagWritten()) {
            return false;
        }
        boolean endOfHeadTagFound = false;
        for (endOfHeadTagPosition = off; endOfHeadTagPosition < length && endOfHeadTagPosition - off < length; ++endOfHeadTagPosition) {
            if (!state.processByte((int)original[endOfHeadTagPosition])) continue;
            endOfHeadTagFound = true;
            break;
        }
        if (!endOfHeadTagFound) {
            return false;
        }
        if (state.getWrapper().isNotSafeToInject()) {
            return false;
        }
        try {
            snippetBytes = this.snippetSupplier.get().getBytes(state.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.FINE, "Failed getting snippet bytes", e);
            return false;
        }
        state.getWrapper().updateContentLengthIfPreviouslySet();
        out.write(original, off, endOfHeadTagPosition + 1);
        out.write(snippetBytes);
        out.write(original, endOfHeadTagPosition + 1, length - endOfHeadTagPosition - 1);
        return true;
    }

    public boolean handleWrite(InjectionState state, OutputStream out, int b) throws IOException {
        byte[] snippetBytes;
        if (state.isHeadTagWritten()) {
            return false;
        }
        if (!state.processByte(b)) {
            return false;
        }
        if (state.getWrapper().isNotSafeToInject()) {
            return false;
        }
        try {
            snippetBytes = this.snippetSupplier.get().getBytes(state.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.FINE, "Failed getting snippet bytes", e);
            return false;
        }
        state.getWrapper().updateContentLengthIfPreviouslySet();
        out.write(b);
        out.write(snippetBytes);
        return true;
    }
}

