/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.snippet;

import io.opentelemetry.javaagent.bootstrap.servlet.InjectionState;
import io.opentelemetry.javaagent.bootstrap.servlet.SnippetInjectingResponseWrapper;
import java.io.PrintWriter;

public class SnippetInjectingPrintWriter
extends PrintWriter {
    private final String snippet;
    private final InjectionState state;

    public SnippetInjectingPrintWriter(PrintWriter writer, String snippet, SnippetInjectingResponseWrapper wrapper) {
        super(writer);
        this.state = new InjectionState(wrapper);
        this.snippet = snippet;
    }

    @Override
    public void write(String s, int off, int len) {
        if (this.state.isHeadTagWritten()) {
            super.write(s, off, len);
            return;
        }
        for (int i = off; i < s.length() && i - off < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void write(int b) {
        super.write(b);
        if (this.state.isHeadTagWritten()) {
            return;
        }
        boolean endOfHeadTagFound = this.state.processByte(b);
        if (!endOfHeadTagFound) {
            return;
        }
        if (this.state.getWrapper().isNotSafeToInject()) {
            return;
        }
        this.state.getWrapper().updateContentLengthIfPreviouslySet();
        super.write(this.snippet);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        if (this.state.isHeadTagWritten()) {
            super.write(buf, off, len);
            return;
        }
        for (int i = off; i < buf.length && i - off < len; ++i) {
            this.write(buf[i]);
        }
    }
}

