/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.javax;

import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public abstract class JavaxServletAccessor<R>
implements ServletAccessor<HttpServletRequest, R> {
    public String getRequestContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public String getRequestScheme(HttpServletRequest request) {
        return request.getScheme();
    }

    public String getRequestUri(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public String getRequestQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    public Object getRequestAttribute(HttpServletRequest request, String name) {
        return request.getAttribute(name);
    }

    public void setRequestAttribute(HttpServletRequest request, String name, Object value) {
        request.setAttribute(name, value);
    }

    public String getRequestProtocol(HttpServletRequest request) {
        return request.getProtocol();
    }

    public String getRequestMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    public String getRequestRemoteAddr(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    public String getRequestHeader(HttpServletRequest request, String name) {
        return request.getHeader(name);
    }

    public List<String> getRequestHeaderValues(HttpServletRequest request, String name) {
        Enumeration values = request.getHeaders(name);
        return values == null ? Collections.emptyList() : Collections.list(values);
    }

    public Iterable<String> getRequestHeaderNames(HttpServletRequest httpServletRequest) {
        Enumeration names = httpServletRequest.getHeaderNames();
        return Collections.list(names);
    }

    public List<String> getRequestParameterValues(HttpServletRequest httpServletRequest, String name) {
        String[] values = httpServletRequest.getParameterValues(name);
        return values == null ? Collections.emptyList() : Arrays.asList(values);
    }

    public String getRequestServletPath(HttpServletRequest request) {
        return request.getServletPath();
    }

    public String getRequestPathInfo(HttpServletRequest request) {
        return request.getPathInfo();
    }

    public Principal getRequestUserPrincipal(HttpServletRequest request) {
        return request.getUserPrincipal();
    }

    public boolean isServletException(Throwable throwable) {
        return throwable instanceof ServletException;
    }
}

