/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.instrumenter;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetAttributesExtractor;
import io.opentelemetry.javaagent.instrumentation.api.instrumenter.ReflectionPeerServiceAttributesExtractorFactory;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PeerServiceAttributesExtractor<REQUEST, RESPONSE>
extends AttributesExtractor<REQUEST, RESPONSE> {
    private static final Map<String, String> JAVAAGENT_PEER_SERVICE_MAPPING = Config.get().getMapProperty("otel.instrumentation.common.peer-service-mapping");
    private final Map<String, String> peerServiceMapping;
    private final NetAttributesExtractor<REQUEST, RESPONSE> netAttributesExtractor;

    PeerServiceAttributesExtractor(Map<String, String> peerServiceMapping, NetAttributesExtractor<REQUEST, RESPONSE> netAttributesExtractor) {
        this.peerServiceMapping = peerServiceMapping;
        this.netAttributesExtractor = netAttributesExtractor;
    }

    public static <REQUEST, RESPONSE> PeerServiceAttributesExtractor<REQUEST, RESPONSE> create(NetAttributesExtractor<REQUEST, RESPONSE> netAttributesExtractor) {
        return new PeerServiceAttributesExtractor<REQUEST, RESPONSE>(JAVAAGENT_PEER_SERVICE_MAPPING, netAttributesExtractor);
    }

    public static <REQUEST, RESPONSE> @Nullable PeerServiceAttributesExtractor<REQUEST, RESPONSE> createUsingReflection(String netAttributesExtractorImplClassName) {
        return ReflectionPeerServiceAttributesExtractorFactory.create(netAttributesExtractorImplClassName);
    }

    protected void onStart(AttributesBuilder attributes, REQUEST request) {
        this.onEnd(attributes, request, null);
    }

    protected void onEnd(AttributesBuilder attributes, REQUEST request, RESPONSE response) {
        String peerName = this.netAttributesExtractor.peerName(request, response);
        String peerService = this.mapToPeerService(peerName);
        if (peerService == null) {
            String peerIp = this.netAttributesExtractor.peerIp(request, response);
            peerService = this.mapToPeerService(peerIp);
        }
        if (peerService != null) {
            attributes.put(SemanticAttributes.PEER_SERVICE, (Object)peerService);
        }
    }

    private String mapToPeerService(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return this.peerServiceMapping.get(endpoint);
    }
}

