/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.instrumenter;

import io.opentelemetry.instrumentation.api.instrumenter.net.NetAttributesExtractor;
import io.opentelemetry.javaagent.instrumentation.api.instrumenter.PeerServiceAttributesExtractor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReflectionPeerServiceAttributesExtractorFactory {
    private static final Logger log = LoggerFactory.getLogger(ReflectionPeerServiceAttributesExtractorFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <REQUEST, RESPONSE> @Nullable PeerServiceAttributesExtractor<REQUEST, RESPONSE> create(String netAttributesImplClassName) {
        Constructor<?> constructor = null;
        try {
            Class<?> netAttributesExtractorClass = Class.forName(netAttributesImplClassName);
            constructor = netAttributesExtractorClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            NetAttributesExtractor netAttributesExtractor = (NetAttributesExtractor)constructor.newInstance(new Object[0]);
            PeerServiceAttributesExtractor peerServiceAttributesExtractor = PeerServiceAttributesExtractor.create(netAttributesExtractor);
            return peerServiceAttributesExtractor;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Could not add PeerServiceAttributesExtractor wrapping {}", (Object)netAttributesImplClassName, (Object)e);
            PeerServiceAttributesExtractor<REQUEST, RESPONSE> peerServiceAttributesExtractor = null;
            return peerServiceAttributesExtractor;
        }
        finally {
            if (constructor != null) {
                constructor.setAccessible(false);
            }
        }
    }

    private ReflectionPeerServiceAttributesExtractorFactory() {
    }
}

