/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentStarter;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.annotation.Nullable;

public final class AgentInitializer {
    @Nullable
    private static ClassLoader agentClassLoader = null;
    @Nullable
    private static AgentStarter agentStarter = null;
    private static boolean isSecurityManagerSupportEnabled = false;
    private static volatile boolean agentStarted = false;

    public static void initialize(final Instrumentation inst, final File javaagentFile, final boolean fromPremain) throws Exception {
        if (agentClassLoader != null) {
            return;
        }
        if (AgentInitializer.class.getClassLoader() != null) {
            throw new IllegalStateException("agent initializer should be loaded in boot loader");
        }
        isSecurityManagerSupportEnabled = AgentInitializer.isSecurityManagerSupportEnabled();
        AgentInitializer.execute(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                agentClassLoader = AgentInitializer.createAgentClassLoader("inst", javaagentFile);
                agentStarter = AgentInitializer.createAgentStarter(agentClassLoader, inst, javaagentFile);
                if (!fromPremain || !AgentInitializer.delayAgentStart()) {
                    agentStarter.start();
                    agentStarted = true;
                }
                return null;
            }
        });
    }

    private static void execute(PrivilegedExceptionAction<Void> action) throws Exception {
        if (isSecurityManagerSupportEnabled) {
            AgentInitializer.doPrivilegedExceptionAction(action);
        } else {
            action.run();
        }
    }

    private static boolean isSecurityManagerSupportEnabled() {
        return AgentInitializer.getBoolean("otel.javaagent.experimental.security-manager-support.enabled", false);
    }

    private static boolean getBoolean(final String property, final boolean defaultValue) {
        return AgentInitializer.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ConfigPropertiesUtil.getBoolean((String)property, (boolean)defaultValue);
            }
        });
    }

    private static <T> T doPrivilegedExceptionAction(PrivilegedExceptionAction<T> action) throws Exception {
        return AccessController.doPrivileged(action);
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    private static boolean isEarlyOracle18() {
        String vmName = System.getProperty("java.vm.name");
        if (!vmName.contains("HotSpot") && !vmName.contains("OpenJDK")) {
            return false;
        }
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.8")) {
            return false;
        }
        int index = javaVersion.indexOf(95);
        if (index == -1) {
            return false;
        }
        String minorVersion = javaVersion.substring(index + 1);
        try {
            int version = Integer.parseInt(minorVersion);
            if (version >= 40) {
                return false;
            }
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    private static boolean delayAgentStart() {
        if (!AgentInitializer.isEarlyOracle18()) {
            return false;
        }
        return agentStarter.delayStart();
    }

    public static void delayedStartHook() throws Exception {
        AgentInitializer.execute(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() {
                agentStarter.start();
                agentStarted = true;
                return null;
            }
        });
    }

    public static boolean isAgentStarted(boolean vmStarted) {
        return vmStarted && agentStarted;
    }

    public static ClassLoader getExtensionsClassLoader() {
        return agentStarter != null ? agentStarter.getExtensionClassLoader() : null;
    }

    private static ClassLoader createAgentClassLoader(String innerJarFilename, File javaagentFile) {
        return new AgentClassLoader(javaagentFile, innerJarFilename, isSecurityManagerSupportEnabled);
    }

    private static AgentStarter createAgentStarter(ClassLoader agentClassLoader, Instrumentation instrumentation, File javaagentFile) throws Exception {
        Class<?> starterClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentStarterImpl");
        Constructor<?> constructor = starterClass.getDeclaredConstructor(Instrumentation.class, File.class, Boolean.TYPE);
        return (AgentStarter)constructor.newInstance(instrumentation, javaagentFile, isSecurityManagerSupportEnabled);
    }

    private AgentInitializer() {
    }
}

