/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.instrumentation;

import io.opentelemetry.javaagent.extension.instrumentation.HelperResourceBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.Ordered;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class InstrumentationModule
implements Ordered {
    private final Set<String> instrumentationNames;

    protected InstrumentationModule(String mainInstrumentationName, String ... additionalInstrumentationNames) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(additionalInstrumentationNames.length + 1);
        names.add(mainInstrumentationName);
        names.addAll(Arrays.asList(additionalInstrumentationNames));
        this.instrumentationNames = Collections.unmodifiableSet(names);
    }

    public final Set<String> instrumentationNames() {
        return this.instrumentationNames;
    }

    public final String instrumentationName() {
        return this.instrumentationNames.iterator().next();
    }

    public boolean defaultEnabled(ConfigProperties config) {
        return config.getBoolean("otel.instrumentation.common.default-enabled", true);
    }

    public boolean isHelperClass(String className) {
        return false;
    }

    public boolean isIndyModule() {
        return false;
    }

    public void registerHelperResources(HelperResourceBuilder helperResourceBuilder) {
    }

    public ElementMatcher.Junction<ClassLoader> classLoaderMatcher() {
        return ElementMatchers.any();
    }

    public abstract List<TypeInstrumentation> typeInstrumentations();

    public List<String> getAdditionalHelperClassNames() {
        return Collections.emptyList();
    }
}

