/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.matcher;

import io.opentelemetry.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.bootstrap.ClassLoaderMatcherCacheHolder;
import io.opentelemetry.javaagent.instrumentation.api.internal.InClassLoaderMatcher;
import net.bytebuddy.matcher.ElementMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ClassLoaderMatcher {
    public static final @Nullable ClassLoader BOOTSTRAP_CLASSLOADER = null;

    private ClassLoaderMatcher() {
        throw new UnsupportedOperationException();
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> hasClassesNamed(String ... classNames) {
        return new ClassLoaderHasClassesNamedMatcher(classNames);
    }

    private static class ClassLoaderHasClassesNamedMatcher
    extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
        private final Cache<ClassLoader, Boolean> cache = Cache.newBuilder().setWeakKeys().setMaximumSize(25L).build();
        private final String[] resources;

        private ClassLoaderHasClassesNamedMatcher(String ... classNames) {
            this.resources = classNames;
            for (int i = 0; i < this.resources.length; ++i) {
                this.resources[i] = this.resources[i].replace(".", "/") + ".class";
            }
            ClassLoaderMatcherCacheHolder.addCache(this.cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasResources(ClassLoader cl) {
            boolean priorValue = InClassLoaderMatcher.getAndSet((boolean)true);
            try {
                for (String resource : this.resources) {
                    if (cl.getResource(resource) != null) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                InClassLoaderMatcher.set((boolean)priorValue);
            }
            return true;
        }

        public boolean matches(ClassLoader cl) {
            if (cl == BOOTSTRAP_CLASSLOADER) {
                return false;
            }
            return (Boolean)this.cache.computeIfAbsent((Object)cl, this::hasResources);
        }
    }
}

