/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.muzzle;

import io.opentelemetry.javaagent.extension.muzzle.Flag;
import io.opentelemetry.javaagent.extension.muzzle.ReferenceMergeUtil;
import io.opentelemetry.javaagent.extension.muzzle.Source;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.jar.asm.Type;

public final class FieldRef {
    private final Set<Source> sources;
    private final Set<Flag> flags;
    private final String name;
    private final String descriptor;
    private final boolean declared;

    FieldRef(Set<Source> sources, Set<Flag> flags, String name, String descriptor, boolean declared) {
        this.sources = sources;
        this.flags = flags;
        this.name = name;
        this.descriptor = descriptor;
        this.declared = declared;
    }

    public Set<Source> getSources() {
        return this.sources;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    FieldRef merge(FieldRef anotherField) {
        if (!this.equals(anotherField) || !this.descriptor.equals(anotherField.descriptor)) {
            throw new IllegalStateException("illegal merge " + this + " != " + anotherField);
        }
        return new FieldRef(ReferenceMergeUtil.mergeSet(this.sources, anotherField.sources), ReferenceMergeUtil.mergeFlags(this.flags, anotherField.flags), this.name, this.descriptor, this.declared || anotherField.declared);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldRef)) {
            return false;
        }
        FieldRef other = (FieldRef)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String modifiers = this.flags.stream().map(Object::toString).collect(Collectors.joining(" "));
        String fieldType = Type.getType((String)this.getDescriptor()).getClassName();
        return this.getClass().getSimpleName() + ": " + modifiers + " " + fieldType + " " + this.name;
    }
}

