/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import io.opentelemetry.instrumentation.api.internal.HttpConstants;
import io.opentelemetry.javaagent.bootstrap.internal.DeprecatedConfigProperties;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CommonConfig {
    private static final CommonConfig instance = new CommonConfig(InstrumentationConfig.get());
    private final Map<String, String> peerServiceMapping;
    private final List<String> clientRequestHeaders;
    private final List<String> clientResponseHeaders;
    private final List<String> serverRequestHeaders;
    private final List<String> serverResponseHeaders;
    private final Set<String> knownHttpRequestMethods;
    private final boolean statementSanitizationEnabled;
    private final boolean emitExperimentalHttpClientMetrics;
    private final boolean emitExperimentalHttpServerMetrics;

    public static CommonConfig get() {
        return instance;
    }

    CommonConfig(InstrumentationConfig config) {
        this.peerServiceMapping = config.getMap("otel.instrumentation.common.peer-service-mapping", Collections.emptyMap());
        this.clientRequestHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.client.request", "otel.instrumentation.http.client.capture-request-headers");
        this.clientResponseHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.client.response", "otel.instrumentation.http.client.capture-response-headers");
        this.serverRequestHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.server.request", "otel.instrumentation.http.server.capture-request-headers");
        this.serverResponseHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.server.response", "otel.instrumentation.http.server.capture-response-headers");
        this.knownHttpRequestMethods = new HashSet<String>(config.getList("otel.instrumentation.http.known-methods", new ArrayList<String>(HttpConstants.KNOWN_METHODS)));
        this.statementSanitizationEnabled = config.getBoolean("otel.instrumentation.common.db-statement-sanitizer.enabled", true);
        this.emitExperimentalHttpClientMetrics = config.getBoolean("otel.instrumentation.http.client.emit-experimental-metrics", false);
        this.emitExperimentalHttpServerMetrics = config.getBoolean("otel.instrumentation.http.server.emit-experimental-metrics", false);
    }

    public Map<String, String> getPeerServiceMapping() {
        return this.peerServiceMapping;
    }

    public List<String> getClientRequestHeaders() {
        return this.clientRequestHeaders;
    }

    public List<String> getClientResponseHeaders() {
        return this.clientResponseHeaders;
    }

    public List<String> getServerRequestHeaders() {
        return this.serverRequestHeaders;
    }

    public List<String> getServerResponseHeaders() {
        return this.serverResponseHeaders;
    }

    public Set<String> getKnownHttpRequestMethods() {
        return this.knownHttpRequestMethods;
    }

    public boolean isStatementSanitizationEnabled() {
        return this.statementSanitizationEnabled;
    }

    public boolean shouldEmitExperimentalHttpClientMetrics() {
        return this.emitExperimentalHttpClientMetrics;
    }

    public boolean shouldEmitExperimentalHttpServerMetrics() {
        return this.emitExperimentalHttpServerMetrics;
    }
}

