/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.internal;

import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.javaagent.extension.internal.DeclarativeConfigPropertiesBridge;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;

public final class ConfigPropertiesUtil {
    private ConfigPropertiesUtil() {
    }

    public static ConfigProperties resolveConfigProperties(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
        ConfigProperties sdkConfigProperties = AutoConfigureUtil.getConfig((AutoConfiguredOpenTelemetrySdk)autoConfiguredOpenTelemetrySdk);
        if (sdkConfigProperties != null) {
            return sdkConfigProperties;
        }
        ConfigProvider configProvider = AutoConfigureUtil.getConfigProvider((AutoConfiguredOpenTelemetrySdk)autoConfiguredOpenTelemetrySdk);
        if (configProvider != null) {
            DeclarativeConfigProperties instrumentationConfig = configProvider.getInstrumentationConfig();
            if (instrumentationConfig == null) {
                instrumentationConfig = DeclarativeConfigProperties.empty();
            }
            return new DeclarativeConfigPropertiesBridge(instrumentationConfig);
        }
        throw new IllegalStateException("AutoConfiguredOpenTelemetrySdk does not have ConfigProperties or DeclarativeConfigProperties. This is likely a programming error in opentelemetry-java");
    }
}

