/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.internal;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class DeclarativeConfigPropertiesBridge
implements ConfigProperties {
    private static final String OTEL_INSTRUMENTATION_PREFIX = "otel.instrumentation.";
    private final DeclarativeConfigProperties instrumentationJavaNode;

    DeclarativeConfigPropertiesBridge(DeclarativeConfigProperties instrumentationNode) {
        this.instrumentationJavaNode = instrumentationNode.getStructured("java", DeclarativeConfigProperties.empty());
    }

    @Nullable
    public String getString(String propertyName) {
        return this.getPropertyValue(propertyName, DeclarativeConfigProperties::getString);
    }

    @Nullable
    public Boolean getBoolean(String propertyName) {
        return this.getPropertyValue(propertyName, DeclarativeConfigProperties::getBoolean);
    }

    @Nullable
    public Integer getInt(String propertyName) {
        return this.getPropertyValue(propertyName, DeclarativeConfigProperties::getInt);
    }

    @Nullable
    public Long getLong(String propertyName) {
        return this.getPropertyValue(propertyName, DeclarativeConfigProperties::getLong);
    }

    @Nullable
    public Double getDouble(String propertyName) {
        return this.getPropertyValue(propertyName, DeclarativeConfigProperties::getDouble);
    }

    @Nullable
    public Duration getDuration(String propertyName) {
        Long millis = this.getPropertyValue(propertyName, DeclarativeConfigProperties::getLong);
        if (millis == null) {
            return null;
        }
        return Duration.ofMillis(millis);
    }

    public List<String> getList(String propertyName) {
        List propertyValue = this.getPropertyValue(propertyName, (properties, lastPart) -> properties.getScalarList(lastPart, String.class));
        return propertyValue == null ? Collections.emptyList() : propertyValue;
    }

    public Map<String, String> getMap(String propertyName) {
        DeclarativeConfigProperties propertyValue = this.getPropertyValue(propertyName, DeclarativeConfigProperties::getStructured);
        if (propertyValue == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        propertyValue.getPropertyKeys().forEach(key -> {
            String value = propertyValue.getString(key);
            if (value == null) {
                return;
            }
            result.put(key, value);
        });
        return Collections.unmodifiableMap(result);
    }

    @Nullable
    private <T> T getPropertyValue(String property, BiFunction<DeclarativeConfigProperties, String, T> extractor) {
        String[] segments;
        if (this.instrumentationJavaNode == null) {
            return null;
        }
        if (property.startsWith(OTEL_INSTRUMENTATION_PREFIX)) {
            property = property.substring(OTEL_INSTRUMENTATION_PREFIX.length());
        }
        if ((segments = property.split("\\.")).length == 0) {
            return null;
        }
        DeclarativeConfigProperties target = this.instrumentationJavaNode;
        if (segments.length > 1) {
            for (int i = 0; i < segments.length - 1; ++i) {
                target = target.getStructured(segments[i], DeclarativeConfigProperties.empty());
            }
        }
        String lastPart = segments[segments.length - 1];
        return extractor.apply(target, lastPart);
    }
}

