/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.matcher;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.bootstrap.internal.ClassLoaderMatcherCacheHolder;
import io.opentelemetry.javaagent.bootstrap.internal.InClassLoaderMatcher;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.bytebuddy.matcher.ElementMatcher;

class ClassLoaderHasClassesNamedMatcher
extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
    static boolean useCache = true;
    private static final AtomicInteger counter = new AtomicInteger();
    private final String[] resources;
    private final int index = counter.getAndIncrement();

    ClassLoaderHasClassesNamedMatcher(String ... classNames) {
        this.resources = classNames;
        for (int i = 0; i < this.resources.length; ++i) {
            this.resources[i] = this.resources[i].replace(".", "/") + ".class";
        }
    }

    public boolean matches(ClassLoader cl) {
        if (cl == null) {
            return false;
        }
        if (useCache) {
            return Manager.INSTANCE.match(this, cl);
        }
        return ClassLoaderHasClassesNamedMatcher.hasResources(cl, this.resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasResources(ClassLoader cl, String ... resources) {
        boolean priorValue = InClassLoaderMatcher.getAndSet(true);
        try {
            for (String resource : resources) {
                if (cl.getResource(resource) != null) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            InClassLoaderMatcher.set(priorValue);
        }
        return true;
    }

    private static class Manager {
        static final Manager INSTANCE = new Manager();
        private final Cache<ClassLoader, BitSet> enabled = Cache.weak();
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();

        Manager() {
            ClassLoaderMatcherCacheHolder.addCache(this.enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(ClassLoaderHasClassesNamedMatcher matcher, ClassLoader cl) {
            BitSet set = (BitSet)this.enabled.computeIfAbsent((Object)cl, unused -> new BitSet(counter.get() * 2));
            int matcherRunBit = 2 * matcher.index;
            int matchedBit = matcherRunBit + 1;
            this.readLock.lock();
            try {
                if (!set.get(matcherRunBit)) {
                    this.readLock.unlock();
                    boolean matches = ClassLoaderHasClassesNamedMatcher.hasResources(cl, matcher.resources);
                    this.writeLock.lock();
                    try {
                        if (!set.get(matcherRunBit)) {
                            if (matches) {
                                set.set(matchedBit);
                            }
                            set.set(matcherRunBit);
                        }
                    }
                    finally {
                        this.readLock.lock();
                        this.writeLock.unlock();
                    }
                }
                boolean bl = set.get(matchedBit);
                return bl;
            }
            finally {
                this.readLock.unlock();
            }
        }
    }
}

