/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class StructuredConfigPropertiesBridge
implements ConfigProperties {
    private static final String OTEL_INSTRUMENTATION_PREFIX = "otel.instrumentation.";
    private final StructuredConfigProperties instrumentationJavaNode;

    StructuredConfigPropertiesBridge(StructuredConfigProperties rootStructuredConfigProperties) {
        this.instrumentationJavaNode = rootStructuredConfigProperties.getStructured("instrumentation", StructuredConfigProperties.empty()).getStructured("java", StructuredConfigProperties.empty());
    }

    @Nullable
    public String getString(String propertyName) {
        return this.getPropertyValue(propertyName, StructuredConfigProperties::getString);
    }

    @Nullable
    public Boolean getBoolean(String propertyName) {
        return this.getPropertyValue(propertyName, StructuredConfigProperties::getBoolean);
    }

    @Nullable
    public Integer getInt(String propertyName) {
        return this.getPropertyValue(propertyName, StructuredConfigProperties::getInt);
    }

    @Nullable
    public Long getLong(String propertyName) {
        return this.getPropertyValue(propertyName, StructuredConfigProperties::getLong);
    }

    @Nullable
    public Double getDouble(String propertyName) {
        return this.getPropertyValue(propertyName, StructuredConfigProperties::getDouble);
    }

    @Nullable
    public Duration getDuration(String propertyName) {
        Long millis = this.getPropertyValue(propertyName, StructuredConfigProperties::getLong);
        if (millis == null) {
            return null;
        }
        return Duration.ofMillis(millis);
    }

    public List<String> getList(String propertyName) {
        List propertyValue = this.getPropertyValue(propertyName, (properties, lastPart) -> properties.getScalarList(lastPart, String.class));
        return propertyValue == null ? Collections.emptyList() : propertyValue;
    }

    public Map<String, String> getMap(String propertyName) {
        StructuredConfigProperties propertyValue = this.getPropertyValue(propertyName, StructuredConfigProperties::getStructured);
        if (propertyValue == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        propertyValue.getPropertyKeys().forEach(key -> {
            String value = propertyValue.getString(key);
            if (value == null) {
                return;
            }
            result.put(key, value);
        });
        return Collections.unmodifiableMap(result);
    }

    @Nullable
    private <T> T getPropertyValue(String property, BiFunction<StructuredConfigProperties, String, T> extractor) {
        if (!property.startsWith(OTEL_INSTRUMENTATION_PREFIX)) {
            return null;
        }
        String suffix = property.substring(OTEL_INSTRUMENTATION_PREFIX.length());
        String[] segments = suffix.split("\\.");
        if (segments.length == 0) {
            return null;
        }
        StructuredConfigProperties target = this.instrumentationJavaNode;
        if (segments.length > 1) {
            for (int i = 0; i < segments.length - 1; ++i) {
                target = target.getStructured(segments[i], StructuredConfigProperties.empty());
            }
        }
        String lastPart = segments[segments.length - 1];
        return extractor.apply(target, lastPart);
    }
}

