/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.logging.simple;

import io.opentelemetry.javaagent.bootstrap.InternalLogger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

final class Slf4jSimpleLogger
implements InternalLogger {
    private final Logger logger;

    static Slf4jSimpleLogger create(String name) {
        return new Slf4jSimpleLogger(name);
    }

    Slf4jSimpleLogger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public boolean isLoggable(InternalLogger.Level level) {
        return this.logger.isEnabledForLevel(Slf4jSimpleLogger.toSlf4jLevel(level));
    }

    public void log(InternalLogger.Level level, String message, @Nullable Throwable error) {
        this.logger.makeLoggingEventBuilder(Slf4jSimpleLogger.toSlf4jLevel(level)).setCause(error).log(message);
    }

    public String name() {
        return this.logger.getName();
    }

    private static Level toSlf4jLevel(InternalLogger.Level level) {
        switch (level) {
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        throw new IllegalStateException("Missing logging level value in switch");
    }
}

