/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.utility.JavaModule;

public class ExposeAgentBootstrapListener
extends AgentBuilder.Listener.Adapter {
    private static final Logger logger = Logger.getLogger(ExposeAgentBootstrapListener.class.getName());
    private static final JavaModule agentBootstrapModule = JavaModule.of((Object)AgentClassLoader.class.getModule());
    private final Instrumentation instrumentation;

    public ExposeAgentBootstrapListener(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b, DynamicType dynamicType) {
        this.exposeModule(javaModule, agentBootstrapModule);
        if (classLoader != null) {
            this.exposeModule(javaModule, JavaModule.of((Object)classLoader.getUnnamedModule()));
        }
    }

    private void exposeModule(JavaModule fromModule, JavaModule targetModule) {
        if (fromModule != JavaModule.UNSUPPORTED && fromModule.isNamed() && !fromModule.canRead(targetModule)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Adding module read from {0} to {1}", new Object[]{fromModule, targetModule});
            }
            ClassInjector.UsingInstrumentation.redefineModule((Instrumentation)this.instrumentation, (JavaModule)fromModule, Collections.singleton(targetModule), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
        }
    }
}

