/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.utility.JavaModule;

public class ModuleOpener {
    private static final Logger logger = Logger.getLogger(ModuleOpener.class.getName());
    private static final JavaModule UNNAMED_BOOT_MODULE = JavaModule.ofType(AgentClassLoader.class);

    private ModuleOpener() {
    }

    public static void open(Instrumentation instrumentation, JavaModule targetModule, @Nullable ClassLoader openTo, Collection<String> packagesToOpen) {
        JavaModule openToModule = openTo != null ? JavaModule.of((Object)openTo.getUnnamedModule()) : UNNAMED_BOOT_MODULE;
        Set<JavaModule> openToModuleSet = Collections.singleton(openToModule);
        HashMap<String, Set<JavaModule>> missingOpens = new HashMap<String, Set<JavaModule>>();
        for (String packageName : packagesToOpen) {
            if (targetModule.isOpened((PackageDescription)new PackageDescription.Simple(packageName), openToModule)) continue;
            missingOpens.put(packageName, openToModuleSet);
            logger.log(Level.FINE, "Exposing package {0} in module {1} to module {2}", new Object[]{packageName, targetModule, openToModule});
        }
        if (missingOpens.isEmpty()) {
            return;
        }
        try {
            ClassInjector.UsingInstrumentation.redefineModule((Instrumentation)instrumentation, (JavaModule)targetModule, Collections.emptySet(), Collections.emptyMap(), missingOpens, Collections.emptySet(), Collections.emptyMap());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to redefine module '" + targetModule.getActualName() + "'", e);
        }
    }
}

